/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.localtime;

import io.netty.channel.Channel;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.ExceptionEvent;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelUpstreamHandler;
import io.netty.example.localtime.LocalTimeProtocol;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalTimeClientHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(LocalTimeClientHandler.class.getName());
    private volatile Channel channel;
    private final BlockingQueue<LocalTimeProtocol.LocalTimes> answer = new LinkedBlockingQueue<LocalTimeProtocol.LocalTimes>();

    public List<String> getLocalTimes(Collection<String> cities) {
        LocalTimeProtocol.LocalTimes localTimes;
        LocalTimeProtocol.Locations.Builder builder = LocalTimeProtocol.Locations.newBuilder();
        for (String c : cities) {
            String[] components = c.split("/");
            builder.addLocation(LocalTimeProtocol.Location.newBuilder().setContinent(LocalTimeProtocol.Continent.valueOf(components[0].toUpperCase())).setCity(components[1]).build());
        }
        this.channel.write(builder.build());
        boolean interrupted = false;
        while (true) {
            try {
                localTimes = this.answer.take();
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (LocalTimeProtocol.LocalTime lt : localTimes.getLocalTimeList()) {
            result.add(new Formatter().format("%4d-%02d-%02d %02d:%02d:%02d %s", lt.getYear(), lt.getMonth(), lt.getDayOfMonth(), lt.getHour(), lt.getMinute(), lt.getSecond(), lt.getDayOfWeek().name()).toString());
        }
        return result;
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof ChannelStateEvent) {
            logger.info(e.toString());
        }
        super.handleUpstream(ctx, e);
    }

    @Override
    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        this.channel = e.getChannel();
        super.channelOpen(ctx, e);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        boolean offered = this.answer.offer((LocalTimeProtocol.LocalTimes)e.getMessage());
        assert (offered);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", e.getCause());
        e.getChannel().close();
    }
}

