/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.log4j.Logger;

public class CurrentState
extends HelixProperty {
    private static Logger LOG = Logger.getLogger(CurrentState.class);

    public CurrentState(String resourceName) {
        super(resourceName);
    }

    public CurrentState(ZNRecord record) {
        super(record);
    }

    public String getResourceName() {
        return this._record.getId();
    }

    public Map<String, String> getPartitionStateMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Map<String, Map<String, String>> mapFields = this._record.getMapFields();
        for (String partitionName : mapFields.keySet()) {
            Map<String, String> tempMap = mapFields.get(partitionName);
            if (tempMap == null) continue;
            map.put(partitionName, tempMap.get(CurrentStateProperty.CURRENT_STATE.toString()));
        }
        return map;
    }

    public String getSessionId() {
        return this._record.getSimpleField(CurrentStateProperty.SESSION_ID.toString());
    }

    public void setSessionId(String sessionId) {
        this._record.setSimpleField(CurrentStateProperty.SESSION_ID.toString(), sessionId);
    }

    public String getState(String partitionName) {
        Map<String, Map<String, String>> mapFields = this._record.getMapFields();
        Map<String, String> mapField = mapFields.get(partitionName);
        if (mapField != null) {
            return mapField.get(CurrentStateProperty.CURRENT_STATE.toString());
        }
        return null;
    }

    public void setStateModelDefRef(String stateModelName) {
        this._record.setSimpleField(CurrentStateProperty.STATE_MODEL_DEF.toString(), stateModelName);
    }

    public String getStateModelDefRef() {
        return this._record.getSimpleField(CurrentStateProperty.STATE_MODEL_DEF.toString());
    }

    public void setState(String partitionName, String state) {
        Map<String, Map<String, String>> mapFields = this._record.getMapFields();
        if (mapFields.get(partitionName) == null) {
            mapFields.put(partitionName, new TreeMap());
        }
        mapFields.get(partitionName).put(CurrentStateProperty.CURRENT_STATE.toString(), state);
    }

    public void setStateModelFactoryName(String factoryName) {
        this._record.setSimpleField(CurrentStateProperty.STATE_MODEL_FACTORY_NAME.toString(), factoryName);
    }

    public String getStateModelFactoryName() {
        return this._record.getSimpleField(CurrentStateProperty.STATE_MODEL_FACTORY_NAME.toString());
    }

    @Override
    public boolean isValid() {
        if (this.getStateModelDefRef() == null) {
            LOG.error((Object)("Current state does not contain state model ref. id:" + this.getResourceName()));
            return false;
        }
        if (this.getSessionId() == null) {
            LOG.error((Object)("CurrentState does not contain session id, id : " + this.getResourceName()));
            return false;
        }
        return true;
    }

    public static enum CurrentStateProperty {
        SESSION_ID,
        CURRENT_STATE,
        STATE_MODEL_DEF,
        STATE_MODEL_FACTORY_NAME,
        RESOURCE;

    }
}

