/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.local;

import io.netty.channel.AbstractServerChannel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.Channels;
import io.netty.channel.DefaultServerChannelConfig;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import java.util.concurrent.atomic.AtomicBoolean;

final class DefaultLocalServerChannel
extends AbstractServerChannel
implements LocalServerChannel {
    final ChannelConfig channelConfig;
    final AtomicBoolean bound = new AtomicBoolean();
    volatile LocalAddress localAddress;

    static DefaultLocalServerChannel create(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        DefaultLocalServerChannel instance = new DefaultLocalServerChannel(factory, pipeline, sink);
        Channels.fireChannelOpen(instance);
        return instance;
    }

    private DefaultLocalServerChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        super(factory, pipeline, sink);
        this.channelConfig = new DefaultServerChannelConfig();
    }

    @Override
    public ChannelConfig getConfig() {
        return this.channelConfig;
    }

    @Override
    public boolean isBound() {
        return this.isOpen() && this.bound.get();
    }

    @Override
    public LocalAddress getLocalAddress() {
        return this.isBound() ? this.localAddress : null;
    }

    @Override
    public LocalAddress getRemoteAddress() {
        return null;
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }
}

