/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp;

import com.sun.nio.sctp.MessageInfo;
import com.sun.nio.sctp.SctpChannel;
import io.netty.buffer.ChannelBuffer;
import io.netty.channel.sctp.SctpFrame;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;

final class SctpSendBufferPool {
    private static final SendBuffer EMPTY_BUFFER = new EmptySendBuffer();
    private static final int DEFAULT_PREALLOCATION_SIZE = 65536;
    private static final int ALIGN_SHIFT = 4;
    private static final int ALIGN_MASK = 15;
    PreallocationRef poolHead;
    Preallocation current = new Preallocation(65536);

    SctpSendBufferPool() {
    }

    SendBuffer acquire(Object message) {
        if (message instanceof SctpFrame) {
            return this.acquire((SctpFrame)message);
        }
        throw new IllegalArgumentException("unsupported message type: " + message.getClass() + " required: io.netty.channel.sctp.SctpFrame");
    }

    private SendBuffer acquire(SctpFrame message) {
        PooledSendBuffer dst;
        ChannelBuffer src = message.getPayloadBuffer();
        int streamNo = message.getStreamIdentifier();
        int protocolId = message.getProtocolIdentifier();
        int size = src.readableBytes();
        if (size == 0) {
            return EMPTY_BUFFER;
        }
        if (src.isDirect()) {
            return new UnpooledSendBuffer(streamNo, protocolId, src.toByteBuffer());
        }
        if (src.readableBytes() > 65536) {
            return new UnpooledSendBuffer(streamNo, protocolId, src.toByteBuffer());
        }
        Preallocation current = this.current;
        ByteBuffer buffer = current.buffer;
        int remaining = buffer.remaining();
        if (size < remaining) {
            int nextPos = buffer.position() + size;
            ByteBuffer slice = buffer.duplicate();
            buffer.position(SctpSendBufferPool.align(nextPos));
            slice.limit(nextPos);
            ++current.refCnt;
            dst = new PooledSendBuffer(streamNo, protocolId, current, slice);
        } else if (size > remaining) {
            this.current = current = this.getPreallocation();
            buffer = current.buffer;
            ByteBuffer slice = buffer.duplicate();
            buffer.position(SctpSendBufferPool.align(size));
            slice.limit(size);
            ++current.refCnt;
            dst = new PooledSendBuffer(streamNo, protocolId, current, slice);
        } else {
            ++current.refCnt;
            this.current = this.getPreallocation0();
            dst = new PooledSendBuffer(streamNo, protocolId, current, current.buffer);
        }
        ByteBuffer dstbuf = dst.buffer;
        dstbuf.mark();
        src.getBytes(src.readerIndex(), dstbuf);
        dstbuf.reset();
        return dst;
    }

    private Preallocation getPreallocation() {
        Preallocation current = this.current;
        if (current.refCnt == 0) {
            current.buffer.clear();
            return current;
        }
        return this.getPreallocation0();
    }

    private Preallocation getPreallocation0() {
        PreallocationRef ref = this.poolHead;
        if (ref != null) {
            do {
                Preallocation p = (Preallocation)ref.get();
                ref = ref.next;
                if (p == null) continue;
                this.poolHead = ref;
                return p;
            } while (ref != null);
            this.poolHead = ref;
        }
        return new Preallocation(65536);
    }

    private static int align(int pos) {
        int q = pos >>> 4;
        int r = pos & 0xF;
        if (r != 0) {
            ++q;
        }
        return q << 4;
    }

    static final class EmptySendBuffer
    implements SendBuffer {
        EmptySendBuffer() {
        }

        @Override
        public boolean finished() {
            return true;
        }

        @Override
        public long writtenBytes() {
            return 0L;
        }

        @Override
        public long totalBytes() {
            return 0L;
        }

        @Override
        public long transferTo(SctpChannel ch) throws IOException {
            return 0L;
        }

        @Override
        public void release() {
        }
    }

    final class PooledSendBuffer
    implements SendBuffer {
        private final Preallocation parent;
        final ByteBuffer buffer;
        final int initialPos;
        final int streamNo;
        final int protocolId;

        PooledSendBuffer(int streamNo, int protocolId, Preallocation parent, ByteBuffer buffer) {
            this.streamNo = streamNo;
            this.protocolId = protocolId;
            this.parent = parent;
            this.buffer = buffer;
            this.initialPos = buffer.position();
        }

        @Override
        public boolean finished() {
            return !this.buffer.hasRemaining();
        }

        @Override
        public long writtenBytes() {
            return this.buffer.position() - this.initialPos;
        }

        @Override
        public long totalBytes() {
            return this.buffer.limit() - this.initialPos;
        }

        @Override
        public long transferTo(SctpChannel ch) throws IOException {
            MessageInfo messageInfo = MessageInfo.createOutgoing(ch.association(), null, this.streamNo);
            messageInfo.payloadProtocolID(this.protocolId);
            messageInfo.streamNumber(this.streamNo);
            ch.send(this.buffer, messageInfo);
            return this.writtenBytes();
        }

        @Override
        public void release() {
            Preallocation parent = this.parent;
            if (--parent.refCnt == 0) {
                parent.buffer.clear();
                if (parent != SctpSendBufferPool.this.current) {
                    SctpSendBufferPool.this.poolHead = new PreallocationRef(parent, SctpSendBufferPool.this.poolHead);
                }
            }
        }
    }

    class UnpooledSendBuffer
    implements SendBuffer {
        final ByteBuffer buffer;
        final int initialPos;
        final int streamNo;
        final int protocolId;

        UnpooledSendBuffer(int streamNo, int protocolId, ByteBuffer buffer) {
            this.streamNo = streamNo;
            this.protocolId = protocolId;
            this.buffer = buffer;
            this.initialPos = buffer.position();
        }

        @Override
        public final boolean finished() {
            return !this.buffer.hasRemaining();
        }

        @Override
        public final long writtenBytes() {
            return this.buffer.position() - this.initialPos;
        }

        @Override
        public final long totalBytes() {
            return this.buffer.limit() - this.initialPos;
        }

        @Override
        public long transferTo(SctpChannel ch) throws IOException {
            MessageInfo messageInfo = MessageInfo.createOutgoing(ch.association(), null, this.streamNo);
            messageInfo.payloadProtocolID(this.protocolId);
            messageInfo.streamNumber(this.streamNo);
            ch.send(this.buffer, messageInfo);
            return this.writtenBytes();
        }

        @Override
        public void release() {
        }
    }

    static interface SendBuffer {
        public boolean finished();

        public long writtenBytes();

        public long totalBytes();

        public long transferTo(SctpChannel var1) throws IOException;

        public void release();
    }

    private final class PreallocationRef
    extends SoftReference<Preallocation> {
        final PreallocationRef next;

        PreallocationRef(Preallocation prealloation, PreallocationRef next) {
            super(prealloation);
            this.next = next;
        }
    }

    private final class Preallocation {
        final ByteBuffer buffer;
        int refCnt;

        Preallocation(int capacity) {
            this.buffer = ByteBuffer.allocateDirect(capacity);
        }
    }
}

