/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp;

import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.ServerChannelFactory;
import io.netty.channel.sctp.SctpServerChannel;
import io.netty.channel.sctp.SctpServerChannelImpl;
import io.netty.channel.sctp.SctpServerPipelineSink;
import io.netty.channel.sctp.SelectorUtil;
import io.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;

public class SctpServerSocketChannelFactory
implements ServerChannelFactory {
    final Executor bossExecutor;
    private final Executor workerExecutor;
    private final ChannelSink sink;

    public SctpServerSocketChannelFactory(Executor bossExecutor, Executor workerExecutor) {
        this(bossExecutor, workerExecutor, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public SctpServerSocketChannelFactory(Executor bossExecutor, Executor workerExecutor, int workerCount) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        if (workerCount <= 0) {
            throw new IllegalArgumentException("workerCount (" + workerCount + ") " + "must be a positive integer.");
        }
        this.bossExecutor = bossExecutor;
        this.workerExecutor = workerExecutor;
        this.sink = new SctpServerPipelineSink(workerExecutor, workerCount);
    }

    @Override
    public SctpServerChannel newChannel(ChannelPipeline pipeline) {
        return new SctpServerChannelImpl(this, pipeline, this.sink);
    }

    @Override
    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.bossExecutor, this.workerExecutor);
    }
}

