/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp.codec;

import io.netty.buffer.ChannelBuffer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.sctp.SctpChannel;
import io.netty.channel.sctp.SctpFrame;
import io.netty.channel.sctp.codec.DefaultOutboundStreamSelector;
import io.netty.channel.sctp.codec.OutboundStreamSelector;
import io.netty.handler.codec.oneone.OneToOneEncoder;

public class SctpFrameEncoder
extends OneToOneEncoder {
    private final int protocolIdentifier;
    private final OutboundStreamSelector sctpWriteStreamSelector;

    public SctpFrameEncoder() {
        this(0);
    }

    public SctpFrameEncoder(int protocolIdentifier) {
        this(protocolIdentifier, new DefaultOutboundStreamSelector());
    }

    public SctpFrameEncoder(int protocolIdentifier, OutboundStreamSelector sctpWriteStreamSelector) {
        if (sctpWriteStreamSelector == null) {
            throw new NullPointerException("sctpWriteStreamSelector");
        }
        this.protocolIdentifier = Math.max(0, protocolIdentifier);
        this.sctpWriteStreamSelector = sctpWriteStreamSelector;
    }

    @Override
    protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
        if (!(msg instanceof ChannelBuffer)) {
            return msg;
        }
        SctpChannel sctpChannel = (SctpChannel)channel;
        int streamIdentifier = this.sctpWriteStreamSelector.streamIdentifier(sctpChannel, msg);
        return new SctpFrame(this.protocolIdentifier, streamIdentifier, (ChannelBuffer)msg);
    }
}

