/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.internal.SystemPropertyUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class NioProviderMetadata {
    static final InternalLogger logger = InternalLoggerFactory.getInstance(NioProviderMetadata.class);
    private static final String CONSTRAINT_LEVEL_PROPERTY = "io.netty.channel.socket.nio.constraintLevel";
    static final int CONSTRAINT_LEVEL;

    private static int detectConstraintLevelFromSystemProperties() {
        String provider;
        String version = SystemPropertyUtil.get("java.specification.version");
        String vminfo = SystemPropertyUtil.get("java.vm.info", "");
        String os = SystemPropertyUtil.get("os.name");
        String vendor = SystemPropertyUtil.get("java.vm.vendor");
        try {
            provider = SelectorProvider.provider().getClass().getName();
        }
        catch (Exception e) {
            provider = null;
        }
        if (version == null || os == null || vendor == null || provider == null) {
            return -1;
        }
        os = os.toLowerCase();
        if ((vendor = vendor.toLowerCase()).indexOf("sun") >= 0) {
            if (os.indexOf("linux") >= 0 ? provider.equals("sun.nio.ch.EPollSelectorProvider") || provider.equals("sun.nio.ch.PollSelectorProvider") : (os.indexOf("windows") >= 0 ? provider.equals("sun.nio.ch.WindowsSelectorProvider") : (os.indexOf("sun") >= 0 || os.indexOf("solaris") >= 0) && provider.equals("sun.nio.ch.DevPollSelectorProvider"))) {
                return 0;
            }
        } else if (vendor.indexOf("apple") >= 0) {
            if (os.indexOf("mac") >= 0 && os.indexOf("os") >= 0 && provider.equals("sun.nio.ch.KQueueSelectorProvider")) {
                return 0;
            }
        } else if (vendor.indexOf("ibm") >= 0) {
            if (os.indexOf("linux") >= 0 || os.indexOf("aix") >= 0) {
                Pattern datePattern;
                Matcher dateMatcher;
                if (version.equals("1.5") || version.matches("^1\\.5\\D.*$")) {
                    if (provider.equals("sun.nio.ch.PollSelectorProvider")) {
                        return 1;
                    }
                } else if ((version.equals("1.6") || version.matches("^1\\.6\\D.*$")) && (dateMatcher = (datePattern = Pattern.compile("(?:^|[^0-9])([2-9][0-9]{3}(?:0[1-9]|1[0-2])(?:0[1-9]|[12][0-9]|3[01]))(?:$|[^0-9])")).matcher(vminfo)).find()) {
                    long dateValue = Long.parseLong(dateMatcher.group(1));
                    if (dateValue < 20081105L) {
                        return 2;
                    }
                    if (provider.equals("sun.nio.ch.EPollSelectorProvider")) {
                        return 0;
                    }
                    if (provider.equals("sun.nio.ch.PollSelectorProvider")) {
                        return 1;
                    }
                }
            }
        } else if (vendor.indexOf("bea") >= 0 || vendor.indexOf("oracle") >= 0) {
            if (os.indexOf("linux") >= 0 ? provider.equals("sun.nio.ch.EPollSelectorProvider") || provider.equals("sun.nio.ch.PollSelectorProvider") : os.indexOf("windows") >= 0 && provider.equals("sun.nio.ch.WindowsSelectorProvider")) {
                return 0;
            }
        } else if (vendor.indexOf("apache") >= 0 && provider.equals("org.apache.harmony.nio.internal.SelectorProviderImpl")) {
            return 1;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        for (Map.Entry<Object, Object> e : System.getProperties().entrySet()) {
            System.out.println(e.getKey() + ": " + e.getValue());
        }
        System.out.println();
        System.out.println("Hard-coded Constraint Level: " + CONSTRAINT_LEVEL);
        System.out.println("Auto-detected Constraint Level: " + new ConstraintLevelAutodetector().autodetect());
    }

    private NioProviderMetadata() {
    }

    static {
        int constraintLevel = -1;
        constraintLevel = SystemPropertyUtil.get(CONSTRAINT_LEVEL_PROPERTY, -1);
        if (constraintLevel < 0 || constraintLevel > 2) {
            constraintLevel = -1;
        }
        if (constraintLevel >= 0) {
            logger.debug("Setting the NIO constraint level to: " + constraintLevel);
        }
        if (constraintLevel < 0) {
            constraintLevel = NioProviderMetadata.detectConstraintLevelFromSystemProperties();
            if (constraintLevel < 0) {
                constraintLevel = 2;
                if (logger.isDebugEnabled()) {
                    logger.debug("Couldn't determine the NIO constraint level from the system properties; using the safest level (2)");
                }
            } else if (constraintLevel != 0) {
                if (logger.isInfoEnabled()) {
                    logger.info("Using the autodetected NIO constraint level: " + constraintLevel + " (Use better NIO provider for better performance)");
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("Using the autodetected NIO constraint level: " + constraintLevel);
            }
        }
        if ((CONSTRAINT_LEVEL = constraintLevel) < 0 || CONSTRAINT_LEVEL > 2) {
            throw new Error("Unexpected NIO constraint level: " + CONSTRAINT_LEVEL + ", please report this error.");
        }
    }

    private static final class SelectorLoop
    implements Runnable {
        final Selector selector = Selector.open();
        volatile boolean done;
        volatile boolean selecting;

        SelectorLoop() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.done) {
                SelectorLoop selectorLoop = this;
                synchronized (selectorLoop) {
                }
                try {
                    this.selecting = true;
                    try {
                        this.selector.select(1000L);
                    }
                    finally {
                        this.selecting = false;
                    }
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    for (SelectionKey k : keys) {
                        k.interestOps(0);
                    }
                    keys.clear();
                }
                catch (IOException e) {
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Failed to wait for a temporary selector.", e);
                }
            }
        }
    }

    private static final class ConstraintLevelAutodetector {
        ConstraintLevelAutodetector() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int autodetect() {
            int constraintLevel;
            block112: {
                ExecutorService executor = Executors.newCachedThreadPool();
                ServerSocketChannel ch = null;
                SelectorLoop loop = null;
                try {
                    long startTime;
                    int i;
                    ch = ServerSocketChannel.open();
                    try {
                        ch.socket().bind(new InetSocketAddress(0));
                        ch.configureBlocking(false);
                    }
                    catch (Throwable e) {
                        int n;
                        block105: {
                            block103: {
                                if (logger.isWarnEnabled()) {
                                    logger.warn("Failed to configure a temporary socket.", e);
                                }
                                n = -1;
                                if (ch != null) {
                                    try {
                                        ch.close();
                                    }
                                    catch (Throwable e2) {
                                        if (!logger.isWarnEnabled()) break block103;
                                        logger.warn("Failed to close a temporary socket.", e2);
                                    }
                                }
                            }
                            if (loop != null) {
                                loop.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e3) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e4) {
                                    // empty catch block
                                }
                                try {
                                    loop.selector.close();
                                }
                                catch (Throwable e5) {
                                    if (!logger.isWarnEnabled()) break block105;
                                    logger.warn("Failed to close a temporary selector.", e5);
                                }
                            }
                        }
                        return n;
                    }
                    try {
                        loop = new SelectorLoop();
                    }
                    catch (Throwable e) {
                        int n;
                        block108: {
                            block106: {
                                if (logger.isWarnEnabled()) {
                                    logger.warn("Failed to open a temporary selector.", e);
                                }
                                n = -1;
                                if (ch != null) {
                                    try {
                                        ch.close();
                                    }
                                    catch (Throwable e6) {
                                        if (!logger.isWarnEnabled()) break block106;
                                        logger.warn("Failed to close a temporary socket.", e6);
                                    }
                                }
                            }
                            if (loop != null) {
                                loop.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e7) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e8) {
                                    // empty catch block
                                }
                                try {
                                    loop.selector.close();
                                }
                                catch (Throwable e9) {
                                    if (!logger.isWarnEnabled()) break block108;
                                    logger.warn("Failed to close a temporary selector.", e9);
                                }
                            }
                        }
                        return n;
                    }
                    try {
                        ch.register(loop.selector, 0);
                    }
                    catch (Throwable e) {
                        int n;
                        block111: {
                            block109: {
                                if (logger.isWarnEnabled()) {
                                    logger.warn("Failed to register a temporary selector.", e);
                                }
                                n = -1;
                                if (ch != null) {
                                    try {
                                        ch.close();
                                    }
                                    catch (Throwable e10) {
                                        if (!logger.isWarnEnabled()) break block109;
                                        logger.warn("Failed to close a temporary socket.", e10);
                                    }
                                }
                            }
                            if (loop != null) {
                                loop.done = true;
                                try {
                                    executor.shutdownNow();
                                }
                                catch (NullPointerException ex) {
                                    // empty catch block
                                }
                                try {
                                    while (true) {
                                        loop.selector.wakeup();
                                        try {
                                            if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                        }
                                        catch (InterruptedException e11) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable e12) {
                                    // empty catch block
                                }
                                try {
                                    loop.selector.close();
                                }
                                catch (Throwable e13) {
                                    if (!logger.isWarnEnabled()) break block111;
                                    logger.warn("Failed to close a temporary selector.", e13);
                                }
                            }
                        }
                        return n;
                    }
                    SelectionKey key = ch.keyFor(loop.selector);
                    executor.execute(loop);
                    boolean success = true;
                    for (i = 0; i < 10; ++i) {
                        while (true) {
                            if (!loop.selecting) {
                                Thread.yield();
                                continue;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (loop.selecting) break;
                        }
                        startTime = System.nanoTime();
                        key.interestOps(key.interestOps() | 0x10);
                        key.interestOps(key.interestOps() & 0xFFFFFFEF);
                        if (System.nanoTime() - startTime < 500000000L) continue;
                        success = false;
                        break;
                    }
                    if (success) {
                        constraintLevel = 0;
                        break block112;
                    }
                    success = true;
                    for (i = 0; i < 10; ++i) {
                        while (true) {
                            if (!loop.selecting) {
                                Thread.yield();
                                continue;
                            }
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            if (loop.selecting) break;
                        }
                        startTime = System.nanoTime();
                        int interestOps = key.interestOps();
                        SelectorLoop e = loop;
                        synchronized (e) {
                            loop.selector.wakeup();
                            key.interestOps(interestOps | 0x10);
                            key.interestOps(interestOps & 0xFFFFFFEF);
                        }
                        if (System.nanoTime() - startTime < 500000000L) continue;
                        success = false;
                        break;
                    }
                    constraintLevel = success ? 1 : 2;
                }
                catch (Throwable e) {
                    int n = -1;
                    return n;
                }
                finally {
                    block115: {
                        block113: {
                            if (ch != null) {
                                try {
                                    ch.close();
                                }
                                catch (Throwable e) {
                                    if (!logger.isWarnEnabled()) break block113;
                                    logger.warn("Failed to close a temporary socket.", e);
                                }
                            }
                        }
                        if (loop != null) {
                            loop.done = true;
                            try {
                                executor.shutdownNow();
                            }
                            catch (NullPointerException ex) {}
                            try {
                                while (true) {
                                    loop.selector.wakeup();
                                    try {
                                        if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                                    }
                                    catch (InterruptedException e) {
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable e) {}
                            try {
                                loop.selector.close();
                            }
                            catch (Throwable e) {
                                if (!logger.isWarnEnabled()) break block115;
                                logger.warn("Failed to close a temporary selector.", e);
                            }
                        }
                    }
                }
            }
            return constraintLevel;
        }
    }
}

