/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.Channels;
import io.netty.channel.socket.oio.OioSocketChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.Socket;
import java.net.SocketAddress;

final class OioAcceptedSocketChannel
extends OioSocketChannel {
    private final PushbackInputStream in;
    private final OutputStream out;

    static OioAcceptedSocketChannel create(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Socket socket) {
        OioAcceptedSocketChannel instance = new OioAcceptedSocketChannel(parent, factory, pipeline, sink, socket);
        Channels.fireChannelOpen(instance);
        Channels.fireChannelBound(instance, (SocketAddress)instance.getLocalAddress());
        return instance;
    }

    private OioAcceptedSocketChannel(Channel parent, ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, Socket socket) {
        super(parent, factory, pipeline, sink, socket);
        try {
            this.in = new PushbackInputStream(socket.getInputStream(), 1);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to obtain an InputStream.", e);
        }
        try {
            this.out = socket.getOutputStream();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to obtain an OutputStream.", e);
        }
    }

    @Override
    PushbackInputStream getInputStream() {
        return this.in;
    }

    @Override
    OutputStream getOutputStream() {
        return this.out;
    }
}

