/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.socket.nio.NioServerSocketChannelFactory;
import io.netty.example.http.snoop.HttpSnoopServerPipelineFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class HttpSnoopServer {
    private final int port;

    public HttpSnoopServer(int port) {
        this.port = port;
    }

    public void run() {
        ServerBootstrap bootstrap = new ServerBootstrap(new NioServerSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new HttpSnoopServerPipelineFactory());
        bootstrap.bind(new InetSocketAddress(this.port));
    }

    public static void main(String[] args) {
        int port = args.length > 0 ? Integer.parseInt(args[0]) : 8080;
        new HttpSnoopServer(port).run();
    }
}

