/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.sctp;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ExceptionEvent;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelUpstreamHandler;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SctpServerHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger logger = Logger.getLogger(SctpServerHandler.class.getName());
    private final AtomicLong counter = new AtomicLong(0L);

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) {
        logger.log(Level.INFO, "Received " + this.counter.incrementAndGet() + "th message from client, sending it back.");
        messageEvent.getChannel().write(messageEvent.getMessage());
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent event) {
        logger.log(Level.WARNING, "Unexpected exception from downstream.", event.getCause());
        event.getChannel().close();
    }
}

