/*
 * Copyright 2011 JBoss, by Red Hat, Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.jboss.errai.bus.client.api;

/**
 * Callback interface for receiving notifications when {@link QueueSession}s end.
 */
public interface SessionEndListener {

  /**
   * Called when the {@link QueueSession} ends.
   * 
   * @param event
   *          The event object that provides a reference to the session that ended. Never null.
   */
  public void onSessionEnd(SessionEndEvent event);
}
