/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Navigate;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.impl.ServiceSupport;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.ProcessorExchangePair;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.UnitOfWorkProcessor;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.apache.camel.processor.aggregate.TimeoutAwareAggregationStrategy;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.spi.TracedRouteNodes;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.EventHelper;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.concurrent.AtomicExchange;
import org.apache.camel.util.concurrent.SubmitOrderedCompletionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastProcessor
extends ServiceSupport
implements AsyncProcessor,
Navigate<Processor>,
Traceable {
    private static final transient Log LOG = LogFactory.getLog(MulticastProcessor.class);
    private final CamelContext camelContext;
    private Collection<Processor> processors;
    private final AggregationStrategy aggregationStrategy;
    private final boolean parallelProcessing;
    private final boolean streaming;
    private final boolean stopOnException;
    private final ExecutorService executorService;
    private final long timeout;

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors) {
        this(camelContext, processors, null);
    }

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors, AggregationStrategy aggregationStrategy) {
        this(camelContext, processors, aggregationStrategy, false, null, false, false, 0L);
    }

    public MulticastProcessor(CamelContext camelContext, Collection<Processor> processors, AggregationStrategy aggregationStrategy, boolean parallelProcessing, ExecutorService executorService, boolean streaming, boolean stopOnException, long timeout) {
        ObjectHelper.notNull(camelContext, "camelContext");
        this.camelContext = camelContext;
        this.processors = processors;
        this.aggregationStrategy = aggregationStrategy;
        this.executorService = executorService;
        this.streaming = streaming;
        this.stopOnException = stopOnException;
        this.parallelProcessing = parallelProcessing || executorService != null;
        this.timeout = timeout;
    }

    public String toString() {
        return "Multicast[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "multicast";
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        AtomicExchange result = new AtomicExchange();
        try {
            boolean sync = true;
            Iterable<ProcessorExchangePair> pairs = this.createProcessorExchangePairs(exchange);
            if (this.isParallelProcessing()) {
                ObjectHelper.notNull(this.executorService, "executorService", this);
                this.doProcessParallel(exchange, result, pairs, this.isStreaming(), callback);
            } else {
                sync = this.doProcessSequential(exchange, result, pairs, callback);
            }
            if (!sync) {
                return false;
            }
        }
        catch (Throwable e) {
            exchange.setException(e);
            this.doDone(exchange, null, callback, true);
            return true;
        }
        Exchange subExchange = result.get() != null ? (Exchange)result.get() : null;
        this.doDone(exchange, subExchange, callback, true);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected void doProcessParallel(Exchange original, AtomicExchange result, Iterable<ProcessorExchangePair> pairs, boolean streaming, AsyncCallback callback) throws InterruptedException, ExecutionException {
        final AtomicBoolean running = new AtomicBoolean(true);
        CompletionService completion = streaming ? new ExecutorCompletionService(this.executorService) : new SubmitOrderedCompletionService(this.executorService);
        final AtomicInteger total = new AtomicInteger(0);
        ArrayList<Future<Exchange>> tasks = new ArrayList<Future<Exchange>>();
        Iterator<ProcessorExchangePair> it = pairs.iterator();
        while (it.hasNext()) {
            final ProcessorExchangePair pair = it.next();
            final Exchange subExchange = pair.getExchange();
            this.updateNewExchange(subExchange, total.intValue(), pairs, it);
            Future<Exchange> task = completion.submit(new Callable<Exchange>(){

                @Override
                public Exchange call() throws Exception {
                    if (!running.get()) {
                        return subExchange;
                    }
                    try {
                        MulticastProcessor.this.doProcessParallel(pair);
                    }
                    catch (Exception e) {
                        subExchange.setException(e);
                    }
                    if (MulticastProcessor.this.stopOnException && subExchange.getException() != null) {
                        running.set(false);
                        throw new CamelExchangeException("Parallel processing failed for number " + total.intValue(), subExchange, subExchange.getException());
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)("Parallel processing complete for exchange: " + subExchange));
                    }
                    return subExchange;
                }
            });
            tasks.add(task);
            total.incrementAndGet();
        }
        boolean timedOut = false;
        StopWatch watch = new StopWatch();
        for (int i = 0; i < total.intValue(); ++i) {
            void var14_17;
            if (timedOut) {
                Future future = completion.poll();
            } else if (this.timeout > 0L) {
                long left = this.timeout - watch.taken();
                if (left < 0L) {
                    left = 0L;
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Polling completion task #" + i + " using timeout " + left + " millis."));
                }
                Future future = completion.poll(left, TimeUnit.MILLISECONDS);
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Polling completion task #" + i));
                }
                Future future = completion.take();
            }
            if (var14_17 == null && timedOut) break;
            if (var14_17 == null) {
                AggregationStrategy strategy = this.getAggregationStrategy(null);
                if (strategy instanceof TimeoutAwareAggregationStrategy) {
                    Exchange oldExchange = (Exchange)result.get();
                    if (oldExchange == null) {
                        oldExchange = original;
                    }
                    ((TimeoutAwareAggregationStrategy)strategy).timeout(oldExchange, i, total.intValue(), this.timeout);
                } else {
                    LOG.warn((Object)("Parallel processing timed out after " + this.timeout + " millis for number " + i + ". This task will be cancelled and will not be aggregated."));
                }
                timedOut = true;
                continue;
            }
            Exchange subExchange = (Exchange)var14_17.get();
            AggregationStrategy strategy = this.getAggregationStrategy(subExchange);
            this.doAggregate(strategy, result, subExchange);
        }
        if (timedOut) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cancelling future tasks due timeout after " + this.timeout + " millis."));
            }
            for (Future future : tasks) {
                future.cancel(true);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done parallel processing " + total + " exchanges"));
        }
    }

    protected boolean doProcessSequential(Exchange original, AtomicExchange result, Iterable<ProcessorExchangePair> pairs, AsyncCallback callback) throws Exception {
        AtomicInteger total = new AtomicInteger();
        Iterator<ProcessorExchangePair> it = pairs.iterator();
        while (it.hasNext()) {
            ProcessorExchangePair pair = it.next();
            Exchange subExchange = pair.getExchange();
            this.updateNewExchange(subExchange, total.get(), pairs, it);
            boolean sync = this.doProcessSequential(original, result, pairs, it, pair, callback, total);
            if (!sync) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Processing exchangeId: " + pair.getExchange().getExchangeId() + " is continued being processed asynchronously"));
                }
                return false;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Processing exchangeId: " + pair.getExchange().getExchangeId() + " is continued being processed synchronously"));
            }
            if (this.stopOnException && subExchange.getException() != null) {
                throw new CamelExchangeException("Sequential processing failed for number " + total.get(), subExchange, subExchange.getException());
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Sequential processing complete for number " + total + " exchange: " + subExchange));
            }
            this.doAggregate(this.getAggregationStrategy(subExchange), result, subExchange);
            total.incrementAndGet();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Done sequential processing " + total + " exchanges"));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcessSequential(final Exchange original, final AtomicExchange result, final Iterable<ProcessorExchangePair> pairs, final Iterator<ProcessorExchangePair> it, final ProcessorExchangePair pair, final AsyncCallback callback, final AtomicInteger total) {
        boolean sync;
        block7: {
            Endpoint endpoint2;
            long timeTaken2;
            sync = true;
            final Exchange exchange = pair.getExchange();
            Processor processor = pair.getProcessor();
            Producer producer = pair.getProducer();
            TracedRouteNodes traced = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getTracedRouteNodes() : null;
            StopWatch watch = null;
            if (producer != null) {
                watch = new StopWatch();
            }
            try {
                if (traced != null) {
                    traced.pushBlock();
                }
                AsyncProcessor async = AsyncProcessorTypeConverter.convert(processor);
                pair.begin();
                sync = AsyncProcessorHelper.process(async, exchange, new AsyncCallback(){

                    public void done(boolean doneSync) {
                        pair.done();
                        if (doneSync) {
                            return;
                        }
                        Exchange subExchange = exchange;
                        if (MulticastProcessor.this.stopOnException && subExchange.getException() != null) {
                            subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, subExchange.getException()));
                            MulticastProcessor.this.doDone(original, subExchange, callback, false);
                            return;
                        }
                        try {
                            MulticastProcessor.this.doAggregate(MulticastProcessor.this.getAggregationStrategy(subExchange), result, subExchange);
                        }
                        catch (Throwable e) {
                            subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, e));
                            MulticastProcessor.this.doDone(original, subExchange, callback, false);
                            return;
                        }
                        total.incrementAndGet();
                        while (it.hasNext()) {
                            ProcessorExchangePair pair2 = (ProcessorExchangePair)it.next();
                            subExchange = pair2.getExchange();
                            MulticastProcessor.this.updateNewExchange(subExchange, total.get(), pairs, it);
                            boolean sync = MulticastProcessor.this.doProcessSequential(original, result, pairs, it, pair2, callback, total);
                            if (!sync) {
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace((Object)("Processing exchangeId: " + original.getExchangeId() + " is continued being processed asynchronously"));
                                }
                                return;
                            }
                            if (MulticastProcessor.this.stopOnException && subExchange.getException() != null) {
                                subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, subExchange.getException()));
                                MulticastProcessor.this.doDone(original, subExchange, callback, false);
                                return;
                            }
                            try {
                                MulticastProcessor.this.doAggregate(MulticastProcessor.this.getAggregationStrategy(subExchange), result, subExchange);
                            }
                            catch (Throwable e) {
                                subExchange.setException(new CamelExchangeException("Sequential processing failed for number " + total, subExchange, e));
                                MulticastProcessor.this.doDone(original, subExchange, callback, false);
                                return;
                            }
                            total.incrementAndGet();
                        }
                        subExchange = result.get() != null ? (Exchange)result.get() : null;
                        MulticastProcessor.this.doDone(original, subExchange, callback, false);
                    }
                });
                Object var16_15 = null;
                if (traced != null) {
                    traced.popBlock();
                }
                if (producer == null) break block7;
                timeTaken2 = watch.stop();
                endpoint2 = producer.getEndpoint();
            }
            catch (Throwable throwable) {
                Object var16_16 = null;
                if (traced != null) {
                    traced.popBlock();
                }
                if (producer != null) {
                    long timeTaken2 = watch.stop();
                    Endpoint endpoint2 = producer.getEndpoint();
                    EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint2, timeTaken2);
                }
                throw throwable;
            }
            EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint2, timeTaken2);
            {
            }
        }
        return sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doProcessParallel(ProcessorExchangePair pair) throws Exception {
        block7: {
            Endpoint endpoint2;
            long timeTaken2;
            Exchange exchange = pair.getExchange();
            Processor processor = pair.getProcessor();
            Producer producer = pair.getProducer();
            TracedRouteNodes traced = exchange.getUnitOfWork() != null ? exchange.getUnitOfWork().getTracedRouteNodes() : null;
            StopWatch watch = null;
            if (producer != null) {
                watch = new StopWatch();
            }
            try {
                if (traced != null) {
                    traced.pushBlock();
                }
                AsyncProcessor async = AsyncProcessorTypeConverter.convert(processor);
                pair.begin();
                AsyncProcessorHelper.process(async, exchange);
                Object var9_8 = null;
                pair.done();
                if (traced != null) {
                    traced.popBlock();
                }
                if (producer == null) break block7;
                timeTaken2 = watch.stop();
                endpoint2 = producer.getEndpoint();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                pair.done();
                if (traced != null) {
                    traced.popBlock();
                }
                if (producer != null) {
                    long timeTaken2 = watch.stop();
                    Endpoint endpoint2 = producer.getEndpoint();
                    EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint2, timeTaken2);
                }
                throw throwable;
            }
            EventHelper.notifyExchangeSent(exchange.getContext(), exchange, endpoint2, timeTaken2);
            {
            }
        }
    }

    protected void doDone(Exchange original, Exchange subExchange, AsyncCallback callback, boolean doneSync) {
        original.removeProperty("CamelAggregationStrategy");
        if (original.getException() != null) {
            original.setProperty("CamelRedeliveryExhausted", Boolean.TRUE);
        }
        if (subExchange != null) {
            ExchangeHelper.copyResults(original, subExchange);
        }
        callback.done(doneSync);
    }

    protected synchronized void doAggregate(AggregationStrategy strategy, AtomicExchange result, Exchange exchange) {
        if (strategy != null) {
            Exchange oldExchange = (Exchange)result.get();
            ExchangeHelper.prepareAggregation(oldExchange, exchange);
            result.set(strategy.aggregate(oldExchange, exchange));
        }
    }

    protected void updateNewExchange(Exchange exchange, int index, Iterable<ProcessorExchangePair> allPairs, Iterator<ProcessorExchangePair> it) {
        exchange.setProperty("CamelMulticastIndex", index);
        if (it.hasNext()) {
            exchange.setProperty("CamelMulticastComplete", Boolean.FALSE);
        } else {
            exchange.setProperty("CamelMulticastComplete", Boolean.TRUE);
        }
    }

    protected Iterable<ProcessorExchangePair> createProcessorExchangePairs(Exchange exchange) throws Exception {
        ArrayList<ProcessorExchangePair> result = new ArrayList<ProcessorExchangePair>(this.processors.size());
        int index = 0;
        for (Processor processor : this.processors) {
            result.add(this.createProcessorExchangePair(index++, processor, exchange));
        }
        return result;
    }

    protected ProcessorExchangePair createProcessorExchangePair(int index, Processor processor, Exchange exchange) {
        Processor prepared = processor;
        Exchange copy = ExchangeHelper.createCorrelatedCopy(exchange, false);
        MulticastProcessor.setToEndpoint(copy, prepared);
        if (exchange.getUnitOfWork() != null && exchange.getUnitOfWork().getRouteContext() != null) {
            RouteContext routeContext = exchange.getUnitOfWork().getRouteContext();
            ErrorHandlerBuilder builder = routeContext.getRoute().getErrorHandlerBuilder();
            try {
                prepared = builder.createErrorHandler(routeContext, prepared);
                prepared = new UnitOfWorkProcessor(prepared);
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        return new DefaultProcessorExchangePair(index, processor, prepared, copy);
    }

    @Override
    protected void doStart() throws Exception {
        if (this.isParallelProcessing() && this.executorService == null) {
            throw new IllegalArgumentException("ParallelProcessing is enabled but ExecutorService has not been set");
        }
        if (this.timeout > 0L && !this.isParallelProcessing()) {
            throw new IllegalArgumentException("Timeout is used but ParallelProcessing has not been enabled");
        }
        ServiceHelper.startServices(this.processors);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.processors);
    }

    protected static void setToEndpoint(Exchange exchange, Processor processor) {
        if (processor instanceof Producer) {
            Producer producer = (Producer)processor;
            exchange.setProperty("CamelToEndpoint", producer.getEndpoint().getEndpointUri());
        }
    }

    protected AggregationStrategy getAggregationStrategy(Exchange exchange) {
        AggregationStrategy answer = null;
        if (exchange != null) {
            answer = exchange.getProperty("CamelAggregationStrategy", AggregationStrategy.class);
        }
        if (answer == null) {
            answer = this.getAggregationStrategy();
        }
        return answer;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isStopOnException() {
        return this.stopOnException;
    }

    public Collection<Processor> getProcessors() {
        return this.processors;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public AggregationStrategy getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public boolean isParallelProcessing() {
        return this.parallelProcessing;
    }

    @Override
    public List<Processor> next() {
        if (!this.hasNext()) {
            return null;
        }
        return new ArrayList<Processor>(this.processors);
    }

    @Override
    public boolean hasNext() {
        return this.processors != null && !this.processors.isEmpty();
    }

    static final class DefaultProcessorExchangePair
    implements ProcessorExchangePair {
        private final int index;
        private final Processor processor;
        private final Processor prepared;
        private final Exchange exchange;

        private DefaultProcessorExchangePair(int index, Processor processor, Processor prepared, Exchange exchange) {
            this.index = index;
            this.processor = processor;
            this.prepared = prepared;
            this.exchange = exchange;
        }

        public int getIndex() {
            return this.index;
        }

        public Exchange getExchange() {
            return this.exchange;
        }

        public Producer getProducer() {
            if (this.processor instanceof Producer) {
                return (Producer)this.processor;
            }
            return null;
        }

        public Processor getProcessor() {
            return this.prepared;
        }

        public void begin() {
            LOG.trace((Object)("ProcessorExchangePair #" + this.index + " begin: " + this.exchange));
        }

        public void done() {
            LOG.trace((Object)("ProcessorExchangePair #" + this.index + " done: " + this.exchange));
        }
    }
}

