/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.alerts;

import java.util.Iterator;
import org.apache.helix.alerts.Aggregator;
import org.apache.helix.alerts.Tuple;

public class WindowAggregator
extends Aggregator {
    int _windowSize;

    public WindowAggregator(String windowSize) {
        this._windowSize = Integer.parseInt(windowSize);
        this._numArgs = 1;
    }

    public WindowAggregator() {
        this("1");
    }

    @Override
    public void merge(Tuple<String> currValTup, Tuple<String> newValTup, Tuple<String> currTimeTup, Tuple<String> newTimeTup, String ... args) {
        this._windowSize = Integer.parseInt(args[0]);
        Tuple<String> mergedTimeTuple = new Tuple<String>();
        Tuple<String> mergedValTuple = new Tuple<String>();
        Iterator<String> currTimeIter = currTimeTup.iterator();
        Iterator<String> currValIter = currValTup.iterator();
        Iterator<String> newTimeIter = newTimeTup.iterator();
        Iterator<String> newValIter = newValTup.iterator();
        int currCtr = 0;
        double currTime = -1.0;
        while (currTimeIter.hasNext()) {
            currTime = Double.parseDouble(currTimeIter.next());
            double currVal = Double.parseDouble(currValIter.next());
            if (++currCtr <= newTimeTup.size() + currTimeTup.size() - this._windowSize) continue;
            mergedTimeTuple.add(String.valueOf(currTime));
            mergedValTuple.add(String.valueOf(currVal));
        }
        while (newTimeIter.hasNext()) {
            double newVal = Double.parseDouble(newValIter.next());
            double newTime = Double.parseDouble(newTimeIter.next());
            if (newTime <= currTime) {
                return;
            }
            if (++currCtr <= newTimeTup.size() + currTimeTup.size() - this._windowSize) continue;
            mergedTimeTuple.add(String.valueOf(newTime));
            mergedValTuple.add(String.valueOf(newVal));
        }
        currTimeTup.clear();
        currTimeTup.addAll(mergedTimeTuple);
        currValTup.clear();
        currValTup.addAll(mergedValTuple);
    }
}

