/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.local;

import io.netty.channel.ChannelDownstreamHandler;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineFactory;
import io.netty.channel.ChannelUpstreamHandler;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.execution.ExecutionHandler;
import java.util.concurrent.Executor;

public class LocalServerPipelineFactory
implements ChannelPipelineFactory {
    private final ExecutionHandler executionHandler;

    public LocalServerPipelineFactory(Executor eventExecutor) {
        this.executionHandler = new ExecutionHandler(eventExecutor);
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("decoder", new StringDecoder());
        pipeline.addLast("encoder", new StringEncoder());
        pipeline.addLast("executor", this.executionHandler);
        pipeline.addLast("handler", new EchoCloseServerHandler());
        return pipeline;
    }

    static class EchoCloseServerHandler
    implements ChannelUpstreamHandler,
    ChannelDownstreamHandler {
        EchoCloseServerHandler() {
        }

        @Override
        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
            MessageEvent evt;
            String msg;
            if (e instanceof MessageEvent && (msg = (String)(evt = (MessageEvent)e).getMessage()).equalsIgnoreCase("quit")) {
                Channels.close(e.getChannel());
                return;
            }
            ctx.sendUpstream(e);
        }

        @Override
        public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) {
            if (e instanceof MessageEvent) {
                MessageEvent evt = (MessageEvent)e;
                String msg = (String)evt.getMessage();
                if (msg.equalsIgnoreCase("quit")) {
                    Channels.close(e.getChannel());
                    return;
                }
                System.err.println("SERVER:" + msg);
                Channels.write(e.getChannel(), msg);
            }
            ctx.sendDownstream(e);
        }
    }
}

