/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBufferFactory;
import java.nio.ByteOrder;

public abstract class AbstractChannelBufferFactory
implements ChannelBufferFactory {
    private final ByteOrder defaultOrder;

    protected AbstractChannelBufferFactory() {
        this(ByteOrder.BIG_ENDIAN);
    }

    protected AbstractChannelBufferFactory(ByteOrder defaultOrder) {
        if (defaultOrder == null) {
            throw new NullPointerException("defaultOrder");
        }
        this.defaultOrder = defaultOrder;
    }

    @Override
    public ChannelBuffer getBuffer(int capacity) {
        return this.getBuffer(this.getDefaultOrder(), capacity);
    }

    @Override
    public ChannelBuffer getBuffer(byte[] array, int offset, int length) {
        return this.getBuffer(this.getDefaultOrder(), array, offset, length);
    }

    @Override
    public ByteOrder getDefaultOrder() {
        return this.defaultOrder;
    }
}

