/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp;

import com.sun.nio.sctp.SctpChannel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.Channels;
import io.netty.channel.sctp.SctpChannelImpl;
import io.netty.channel.sctp.SctpWorker;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import java.io.IOException;

final class SctpClientChannel
extends SctpChannelImpl {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SctpClientChannel.class);
    volatile ChannelFuture connectFuture;
    volatile boolean boundManually;
    long connectDeadlineNanos;

    private static SctpChannel newChannael() {
        SctpChannel underlayingChannel;
        try {
            underlayingChannel = SctpChannel.open();
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a sctp channel.", e);
        }
        boolean success = false;
        try {
            underlayingChannel.configureBlocking(false);
            success = true;
        }
        catch (IOException e) {
            throw new ChannelException("Failed to enter non-blocking mode.", e);
        }
        finally {
            block13: {
                if (!success) {
                    try {
                        underlayingChannel.close();
                    }
                    catch (IOException e) {
                        if (!logger.isWarnEnabled()) break block13;
                        logger.warn("Failed to close a partially initialized socket.", e);
                    }
                }
            }
        }
        return underlayingChannel;
    }

    SctpClientChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink, SctpWorker worker) {
        super(null, factory, pipeline, sink, SctpClientChannel.newChannael(), worker);
        Channels.fireChannelOpen(this);
    }
}

