/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.ClientSocketChannelFactory;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioClientSocketChannel;
import io.netty.channel.socket.nio.NioClientSocketPipelineSink;
import io.netty.channel.socket.nio.SelectorUtil;
import io.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;

public class NioClientSocketChannelFactory
implements ClientSocketChannelFactory {
    private static final int DEFAULT_BOSS_COUNT = 1;
    private final Executor bossExecutor;
    private final Executor workerExecutor;
    private final NioClientSocketPipelineSink sink;

    public NioClientSocketChannelFactory(Executor bossExecutor, Executor workerExecutor) {
        this(bossExecutor, workerExecutor, 1, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public NioClientSocketChannelFactory(Executor bossExecutor, Executor workerExecutor, int workerCount) {
        this(bossExecutor, workerExecutor, 1, workerCount);
    }

    public NioClientSocketChannelFactory(Executor bossExecutor, Executor workerExecutor, int bossCount, int workerCount) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        if (bossCount <= 0) {
            throw new IllegalArgumentException("bossCount (" + bossCount + ") " + "must be a positive integer.");
        }
        if (workerCount <= 0) {
            throw new IllegalArgumentException("workerCount (" + workerCount + ") " + "must be a positive integer.");
        }
        this.bossExecutor = bossExecutor;
        this.workerExecutor = workerExecutor;
        this.sink = new NioClientSocketPipelineSink(bossExecutor, workerExecutor, bossCount, workerCount);
    }

    @Override
    public SocketChannel newChannel(ChannelPipeline pipeline) {
        return NioClientSocketChannel.create(this, pipeline, this.sink, this.sink.nextWorker());
    }

    @Override
    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.bossExecutor, this.workerExecutor);
    }
}

