/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.Channels;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramChannelConfig;
import io.netty.channel.socket.DefaultDatagramChannelConfig;
import io.netty.channel.socket.oio.AbstractOioChannel;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;

final class OioDatagramChannel
extends AbstractOioChannel
implements DatagramChannel {
    final MulticastSocket socket;
    private final DatagramChannelConfig config;

    static OioDatagramChannel create(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        OioDatagramChannel instance = new OioDatagramChannel(factory, pipeline, sink);
        Channels.fireChannelOpen(instance);
        return instance;
    }

    private OioDatagramChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        super(null, factory, pipeline, sink);
        try {
            this.socket = new MulticastSocket(null);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a datagram socket.", e);
        }
        try {
            this.socket.setSoTimeout(10);
            this.socket.setBroadcast(false);
        }
        catch (SocketException e) {
            throw new ChannelException("Failed to configure the datagram socket timeout.", e);
        }
        this.config = new DefaultDatagramChannelConfig(this.socket);
    }

    @Override
    public DatagramChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public void joinGroup(InetAddress multicastAddress) {
        this.ensureBound();
        try {
            this.socket.joinGroup(multicastAddress);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public void joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        this.ensureBound();
        try {
            this.socket.joinGroup(multicastAddress, networkInterface);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void ensureBound() {
        if (!this.isBound()) {
            throw new IllegalStateException(DatagramChannel.class.getName() + " must be bound to join a group.");
        }
    }

    @Override
    public void leaveGroup(InetAddress multicastAddress) {
        try {
            this.socket.leaveGroup(multicastAddress);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public void leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        try {
            this.socket.leaveGroup(multicastAddress, networkInterface);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    boolean isSocketBound() {
        return this.socket.isBound();
    }

    @Override
    boolean isSocketConnected() {
        return this.socket.isConnected();
    }

    @Override
    InetSocketAddress getLocalSocketAddress() throws Exception {
        return (InetSocketAddress)this.socket.getLocalSocketAddress();
    }

    @Override
    InetSocketAddress getRemoteSocketAddress() throws Exception {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    @Override
    void closeSocket() throws IOException {
        this.socket.close();
    }

    @Override
    boolean isSocketClosed() {
        return this.socket.isClosed();
    }
}

