/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.embedder;

import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelSink;
import io.netty.channel.DefaultChannelConfig;
import io.netty.handler.codec.embedder.EmbeddedChannelFactory;
import io.netty.handler.codec.embedder.EmbeddedSocketAddress;
import java.net.SocketAddress;

class EmbeddedChannel
extends AbstractChannel {
    private static final Integer DUMMY_ID = 0;
    private final ChannelConfig config;
    private final SocketAddress localAddress = new EmbeddedSocketAddress();
    private final SocketAddress remoteAddress = new EmbeddedSocketAddress();

    EmbeddedChannel(ChannelPipeline pipeline, ChannelSink sink) {
        super(DUMMY_ID, null, EmbeddedChannelFactory.INSTANCE, pipeline, sink);
        this.config = new DefaultChannelConfig();
    }

    @Override
    public ChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public boolean isBound() {
        return true;
    }

    @Override
    public boolean isConnected() {
        return true;
    }
}

