/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.traffic;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelStateEvent;
import io.netty.handler.traffic.AbstractTrafficShapingHandler;
import io.netty.handler.traffic.TrafficCounter;
import java.util.concurrent.Executor;

public class ChannelTrafficShapingHandler
extends AbstractTrafficShapingHandler {
    public ChannelTrafficShapingHandler(Executor executor, long writeLimit, long readLimit, long checkInterval) {
        super(executor, writeLimit, readLimit, checkInterval);
    }

    public ChannelTrafficShapingHandler(Executor executor, long writeLimit, long readLimit) {
        super(executor, writeLimit, readLimit);
    }

    @Override
    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (this.trafficCounter != null) {
            this.trafficCounter.stop();
            this.trafficCounter = null;
        }
        super.channelClosed(ctx, e);
    }

    @Override
    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ctx.setAttachment(Boolean.TRUE);
        ctx.getChannel().setReadable(false);
        if (this.trafficCounter == null) {
            this.trafficCounter = new TrafficCounter(this, this.executor, "ChannelTC" + ctx.getChannel().getId(), this.checkInterval);
        }
        if (this.trafficCounter != null) {
            this.trafficCounter.start();
        }
        super.channelConnected(ctx, e);
        ctx.setAttachment(null);
        ctx.getChannel().setReadable(true);
    }
}

