/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.buffer.ChannelBuffer;
import io.netty.channel.ChannelFuture;
import io.netty.channel.Channels;
import io.netty.channel.FileRegion;
import io.netty.channel.socket.oio.AbstractOioWorker;
import io.netty.channel.socket.oio.OioSocketChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import java.util.regex.Pattern;

class OioWorker
extends AbstractOioWorker<OioSocketChannel> {
    private static final Pattern SOCKET_CLOSED_MESSAGE = Pattern.compile("^.*(?:Socket.*closed).*$", 2);

    OioWorker(OioSocketChannel channel) {
        super(channel);
    }

    @Override
    boolean process() throws IOException {
        PushbackInputStream in = ((OioSocketChannel)this.channel).getInputStream();
        int bytesToRead = in.available();
        if (bytesToRead <= 0) {
            int b = in.read();
            if (b < 0) {
                return false;
            }
            in.unread(b);
            return true;
        }
        byte[] buf = new byte[bytesToRead];
        int readBytes = in.read(buf);
        Channels.fireMessageReceived(this.channel, (Object)((OioSocketChannel)this.channel).getConfig().getBufferFactory().getBuffer(buf, 0, readBytes));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void write(OioSocketChannel channel, ChannelFuture future, Object message) {
        OutputStream out = channel.getOutputStream();
        if (out == null) {
            ClosedChannelException e = new ClosedChannelException();
            future.setFailure(e);
            Channels.fireExceptionCaught(channel, (Throwable)e);
            return;
        }
        try {
            int length;
            block16: {
                length = 0;
                if (message instanceof FileRegion) {
                    FileRegion fr = (FileRegion)message;
                    try {
                        OutputStream outputStream = out;
                        synchronized (outputStream) {
                            WritableByteChannel bchannel = java.nio.channels.Channels.newChannel(out);
                            long i = 0L;
                            while ((i = fr.transferTo(bchannel, length)) > 0L && (long)(length = (int)((long)length + i)) < fr.getCount()) {
                            }
                            break block16;
                        }
                    }
                    finally {
                        if (fr.releaseAfterTransfer()) {
                            fr.releaseExternalResources();
                        }
                    }
                }
                ChannelBuffer a = (ChannelBuffer)message;
                length = a.readableBytes();
                OutputStream outputStream = out;
                synchronized (outputStream) {
                    a.getBytes(a.readerIndex(), out, length);
                }
            }
            Channels.fireWriteComplete(channel, (long)length);
            future.setSuccess();
        }
        catch (Throwable t2) {
            ClosedChannelException t2;
            if (t2 instanceof SocketException && SOCKET_CLOSED_MESSAGE.matcher(String.valueOf(t2.getMessage())).matches()) {
                t2 = new ClosedChannelException();
            }
            future.setFailure(t2);
            Channels.fireExceptionCaught(channel, (Throwable)t2);
        }
    }
}

