/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.echo;

import io.netty.bootstrap.ClientBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineFactory;
import io.netty.channel.Channels;
import io.netty.channel.socket.nio.NioClientSocketChannelFactory;
import io.netty.example.echo.EchoClientHandler;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class EchoClient {
    private final String host;
    private final int port;
    private final int firstMessageSize;

    public EchoClient(String host, int port, int firstMessageSize) {
        this.host = host;
        this.port = port;
        this.firstMessageSize = firstMessageSize;
    }

    public void run() {
        ClientBootstrap bootstrap = new ClientBootstrap(new NioClientSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline(new EchoClientHandler(EchoClient.this.firstMessageSize));
            }
        });
        ChannelFuture future = bootstrap.connect(new InetSocketAddress(this.host, this.port));
        future.getChannel().getCloseFuture().awaitUninterruptibly();
        bootstrap.releaseExternalResources();
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            System.err.println("Usage: " + EchoClient.class.getSimpleName() + " <host> <port> [<first message size>]");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        int firstMessageSize = args.length == 3 ? Integer.parseInt(args[2]) : 256;
        new EchoClient(host, port, firstMessageSize).run();
    }
}

