/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.language;

import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.component.language.LanguageEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.ObjectHelper;

public class LanguageProducer
extends DefaultProducer {
    public LanguageProducer(LanguageEndpoint endpoint) {
        super(endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        String script;
        Expression exp = exchange.getIn().getHeader("CamelLanguageScript", Expression.class);
        if (exp == null && (script = exchange.getIn().getHeader("CamelLanguageScript", String.class)) != null) {
            exp = this.getEndpoint().getLanguage().createExpression(script);
        }
        if (exp == null) {
            exp = this.getEndpoint().getExpression();
        }
        ObjectHelper.notNull(exp, "expression");
        Object result = exp.evaluate(exchange, Object.class);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Evaluated expression as: " + result + " with: " + exchange));
        }
        if (this.getEndpoint().isTransform()) {
            if (exchange.hasOut()) {
                exchange.getOut().setBody(result);
            } else {
                exchange.getIn().setBody(result);
            }
        }
    }

    public LanguageEndpoint getEndpoint() {
        return (LanguageEndpoint)super.getEndpoint();
    }
}

