/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.IsSingleton;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.language.simple.SimpleLanguage;
import org.apache.camel.language.simple.SimpleLanguageOperator;
import org.apache.camel.spi.Language;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SimpleLanguageSupport
implements Language,
IsSingleton {
    protected static final String OPERATOR_REGEX = "\\$\\{(\\S+)\\}\\s+(==|>|>=|<|<=|!=|contains|not contains|regex|not regex|in|not in|is|not is|range|not range)\\s+('.*?'|\\S+)";
    protected static final Pattern OPERATOR_PATTERN = Pattern.compile("\\$\\{(\\S+)\\}\\s+(==|>|>=|<|<=|!=|contains|not contains|regex|not regex|in|not in|is|not is|range|not range)\\s+('.*?'|\\S+)");
    protected static final Pattern ANDOR_PATTERN = Pattern.compile("\\s+(and|or)\\s+\\$\\{(\\S+)\\}\\s+(==|>|>=|<|<=|!=|contains|not contains|regex|not regex|in|not in|is|not is|range|not range)\\s+('.*?'|\\S+)");
    protected static final Pattern START_ANDOR_PATTERN = Pattern.compile("^\\$\\{(\\S+)\\}\\s+(==|>|>=|<|<=|!=|contains|not contains|regex|not regex|in|not in|is|not is|range|not range)\\s+('.*?'|\\S+)\\s+(and|or)\\s+.*$");
    protected static final Pattern RANGE_PATTERN = Pattern.compile("^(\\d+)(\\.\\.)(\\d+)$");
    protected final Log log = LogFactory.getLog(this.getClass());

    public Predicate createPredicate(String expression) {
        return PredicateBuilder.toPredicate(this.createExpression(expression));
    }

    public Expression createExpression(String expression) {
        Matcher matcher = OPERATOR_PATTERN.matcher(expression);
        Matcher startMatcher = START_ANDOR_PATTERN.matcher(expression);
        if (matcher.matches() || startMatcher.matches()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Expression is evaluated as simple (with operator) expression: " + expression));
            }
            return this.createOperatorExpression(matcher, startMatcher, expression);
        }
        if (SimpleLanguage.hasStartToken(expression)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Expression is evaluated as simple (strict) expression: " + expression));
            }
            return this.createComplexConcatExpression(expression);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Expression is evaluated as simple (non strict) expression: " + expression));
        }
        return this.createSimpleExpression(expression, false);
    }

    private Expression createOperatorExpression(Matcher matcher, Matcher startMatcher, String expression) {
        Expression answer = null;
        if (startMatcher.matches()) {
            answer = this.doCreateOperatorExpression(expression, startMatcher.group(1), startMatcher.group(2), startMatcher.group(3));
        } else if (matcher.matches()) {
            answer = this.doCreateOperatorExpression(expression, matcher.group(1), matcher.group(2), matcher.group(3));
        }
        answer = this.appendAdditionalOperatorExpressions(answer, expression);
        return answer;
    }

    private Expression appendAdditionalOperatorExpressions(final Expression answer, String expression) {
        Matcher matcher = ANDOR_PATTERN.matcher(expression);
        final ArrayList<ExpressionGroup> expressions = new ArrayList<ExpressionGroup>();
        while (matcher.find()) {
            this.dumpMatcher(matcher);
            SimpleLanguageOperator operator = SimpleLanguageOperator.asOperator(matcher.group(1));
            if (operator != SimpleLanguageOperator.AND && operator != SimpleLanguageOperator.OR) {
                throw new IllegalArgumentException("Syntax error in expression: " + expression + ". Expected operator as either and/or but was: " + (Object)((Object)operator));
            }
            Expression exp = this.doCreateOperatorExpression(expression, matcher.group(2), matcher.group(3), matcher.group(4));
            expressions.add(new ExpressionGroup(operator, exp));
        }
        return new Expression(){

            @Override
            public <T> T evaluate(Exchange exchange, Class<T> type) {
                boolean matches = PredicateBuilder.toPredicate(answer).matches(exchange);
                for (ExpressionGroup group : expressions) {
                    boolean result = PredicateBuilder.toPredicate((Expression)group.getValue()).matches(exchange);
                    if (group.getKey() == SimpleLanguageOperator.AND) {
                        matches &= result;
                        continue;
                    }
                    matches |= result;
                }
                return exchange.getContext().getTypeConverter().convertTo(type, matches);
            }

            public String toString() {
                StringBuilder msg = new StringBuilder(answer.toString());
                for (ExpressionGroup group : expressions) {
                    msg.append(" ");
                    msg.append(group.getKey());
                    msg.append(" ");
                    msg.append(group.getValue());
                }
                return msg.toString();
            }
        };
    }

    private void dumpMatcher(Matcher matcher) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Matcher start: " + matcher.start()));
            this.log.trace((Object)("Matcher end: " + matcher.end()));
            this.log.trace((Object)("Matcher group: " + matcher.group()));
            this.log.trace((Object)("Matcher group count: " + matcher.groupCount()));
            for (int i = 0; i < matcher.groupCount() + 1; ++i) {
                String group = matcher.group(i);
                this.log.trace((Object)("Matcher group #" + i + ": " + group));
            }
        }
    }

    private Expression doCreateOperatorExpression(final String expression, String leftText, final String operatorText, String rightText) {
        Expression right;
        Boolean isNull;
        final Expression left = this.createSimpleExpression(leftText, true);
        final SimpleLanguageOperator operator = SimpleLanguageOperator.asOperator(operatorText);
        if ("null".equals(rightText) || "'null'".equals(rightText)) {
            isNull = Boolean.TRUE;
            right = this.createSimpleOrConstantExpression(null);
        } else {
            isNull = Boolean.FALSE;
            right = this.createSimpleOrConstantExpression(rightText);
        }
        return new Expression(){

            @Override
            public <T> T evaluate(Exchange exchange, Class<T> type) {
                Predicate predicate = null;
                if (operator == SimpleLanguageOperator.EQ && isNull.booleanValue()) {
                    predicate = PredicateBuilder.isNull(left);
                } else if (operator == SimpleLanguageOperator.NOT && isNull.booleanValue()) {
                    predicate = PredicateBuilder.isNotNull(left);
                } else if (operator == SimpleLanguageOperator.EQ) {
                    predicate = PredicateBuilder.isEqualTo(left, right);
                } else if (operator == SimpleLanguageOperator.GT) {
                    predicate = PredicateBuilder.isGreaterThan(left, right);
                } else if (operator == SimpleLanguageOperator.GTE) {
                    predicate = PredicateBuilder.isGreaterThanOrEqualTo(left, right);
                } else if (operator == SimpleLanguageOperator.LT) {
                    predicate = PredicateBuilder.isLessThan(left, right);
                } else if (operator == SimpleLanguageOperator.LTE) {
                    predicate = PredicateBuilder.isLessThanOrEqualTo(left, right);
                } else if (operator == SimpleLanguageOperator.NOT) {
                    predicate = PredicateBuilder.isNotEqualTo(left, right);
                } else if (operator == SimpleLanguageOperator.CONTAINS || operator == SimpleLanguageOperator.NOT_CONTAINS) {
                    predicate = PredicateBuilder.contains(left, right);
                    if (operator == SimpleLanguageOperator.NOT_CONTAINS) {
                        predicate = PredicateBuilder.not(predicate);
                    }
                } else if (operator == SimpleLanguageOperator.REGEX || operator == SimpleLanguageOperator.NOT_REGEX) {
                    predicate = PredicateBuilder.regex(left, right.evaluate(exchange, String.class));
                    if (operator == SimpleLanguageOperator.NOT_REGEX) {
                        predicate = PredicateBuilder.not(predicate);
                    }
                } else if (operator == SimpleLanguageOperator.IN || operator == SimpleLanguageOperator.NOT_IN) {
                    Iterator<Object> it = ObjectHelper.createIterator(right.evaluate(exchange, Object.class));
                    ArrayList<Object> values = new ArrayList<Object>();
                    while (it.hasNext()) {
                        values.add(it.next());
                    }
                    ValueBuilder vb = new ValueBuilder(left);
                    predicate = vb.in(values.toArray());
                    if (operator == SimpleLanguageOperator.NOT_IN) {
                        predicate = PredicateBuilder.not(predicate);
                    }
                } else if (operator == SimpleLanguageOperator.IS || operator == SimpleLanguageOperator.NOT_IS) {
                    String name = right.evaluate(exchange, String.class);
                    Class<?> rightType = exchange.getContext().getClassResolver().resolveClass(name);
                    if (rightType == null) {
                        throw new IllegalArgumentException("Syntax error in " + operatorText + " operator: " + expression + " cannot find class with name: " + name);
                    }
                    predicate = PredicateBuilder.isInstanceOf(left, rightType);
                    if (operator == SimpleLanguageOperator.NOT_IS) {
                        predicate = PredicateBuilder.not(predicate);
                    }
                } else if (operator == SimpleLanguageOperator.RANGE || operator == SimpleLanguageOperator.NOT_RANGE) {
                    String range = right.evaluate(exchange, String.class);
                    Matcher matcher = RANGE_PATTERN.matcher(range);
                    if (!matcher.matches()) {
                        throw new IllegalArgumentException("Syntax error in " + operatorText + " operator: " + expression + " is not valid. Valid syntax:from..to(where from and to are numbers).");
                    }
                    Expression from = ExpressionBuilder.constantExpression(matcher.group(1));
                    Expression to = ExpressionBuilder.constantExpression(matcher.group(3));
                    predicate = PredicateBuilder.isGreaterThanOrEqualTo(left, from);
                    predicate = PredicateBuilder.and(predicate, PredicateBuilder.isLessThanOrEqualTo(left, to));
                    if (operator == SimpleLanguageOperator.NOT_RANGE) {
                        predicate = PredicateBuilder.not(predicate);
                    }
                }
                if (predicate == null) {
                    throw new IllegalArgumentException("Unsupported operator: " + operatorText + " for expression: " + expression);
                }
                boolean matches = predicate.matches(exchange);
                return exchange.getContext().getTypeConverter().convertTo(type, matches);
            }

            public String toString() {
                return left + " " + (Object)((Object)operator) + " " + right;
            }
        };
    }

    protected Expression createComplexConcatExpression(String expression) {
        ArrayList<Expression> results = new ArrayList<Expression>();
        int pivot = 0;
        int size = expression.length();
        while (pivot < size) {
            int endIdx;
            int delta = 2;
            int idx = expression.indexOf("${", pivot);
            if (idx < 0) {
                idx = expression.indexOf("$simple{", pivot);
                delta = 8;
            }
            if (idx < 0) {
                results.add(this.createConstantExpression(expression, pivot, size));
                break;
            }
            if (pivot < idx) {
                results.add(this.createConstantExpression(expression, pivot, idx));
            }
            if ((endIdx = expression.indexOf(125, pivot = idx + delta)) < 0) {
                throw new IllegalArgumentException("Expecting } but found end of string for simple expression: " + expression);
            }
            String simpleText = expression.substring(pivot, endIdx);
            Expression simpleExpression = this.createSimpleExpression(simpleText, true);
            results.add(simpleExpression);
            pivot = endIdx + 1;
        }
        if (results.size() > 1) {
            return ExpressionBuilder.concatExpression(results, expression);
        }
        if (results.size() == 1) {
            return (Expression)results.get(0);
        }
        return null;
    }

    protected Expression createSimpleOrConstantExpression(String text) {
        if (text != null) {
            String simple = ObjectHelper.between(text, "${", "}");
            if (simple == null) {
                simple = ObjectHelper.between(text, "$simple{", "}");
            }
            if (simple != null) {
                return this.createSimpleExpression(simple, true);
            }
            simple = ObjectHelper.between(text, "'", "'");
            if (simple != null) {
                return this.createConstantExpression(simple);
            }
        }
        return this.createConstantExpression(text);
    }

    protected Expression createConstantExpression(String expression, int start, int end) {
        return ExpressionBuilder.constantExpression(expression.substring(start, end));
    }

    protected Expression createConstantExpression(String expression) {
        return ExpressionBuilder.constantExpression(expression);
    }

    protected abstract Expression createSimpleExpression(String var1, boolean var2);

    protected String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ExpressionGroup
    extends KeyValueHolder<SimpleLanguageOperator, Expression> {
        public ExpressionGroup(SimpleLanguageOperator key, Expression value) {
            super(key, value);
        }

        @Override
        public String toString() {
            return this.getKey() + " " + this.getValue();
        }
    }
}

