/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.processor.RoutingSlip;
import org.apache.camel.util.ObjectHelper;

public class DynamicRouter
extends RoutingSlip {
    public DynamicRouter(CamelContext camelContext) {
        super(camelContext);
    }

    public DynamicRouter(CamelContext camelContext, Expression expression, String uriDelimiter) {
        super(camelContext, expression, uriDelimiter);
    }

    protected RoutingSlip.RoutingSlipIterator createRoutingSlipIterator(Exchange exchange) {
        return new DynamicRoutingSlipIterator(this.expression);
    }

    private final class DynamicRoutingSlipIterator
    implements RoutingSlip.RoutingSlipIterator {
        private final Expression slip;
        private Iterator current;

        private DynamicRoutingSlipIterator(Expression slip) {
            this.slip = slip;
        }

        public boolean hasNext(Exchange exchange) {
            if (this.current != null && this.current.hasNext()) {
                return true;
            }
            Object routingSlip = this.slip.evaluate(exchange, Object.class);
            if (routingSlip == null) {
                return false;
            }
            this.current = ObjectHelper.createIterator(routingSlip, DynamicRouter.this.uriDelimiter);
            return this.current != null && this.current.hasNext();
        }

        public Object next(Exchange exchange) {
            return this.current.next();
        }
    }
}

