/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Processor;
import org.apache.camel.processor.loadbalancer.DistributionRatio;
import org.apache.camel.processor.loadbalancer.QueueLoadBalancer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WeightedLoadBalancer
extends QueueLoadBalancer {
    private static final transient Log LOG = LogFactory.getLog(WeightedLoadBalancer.class);
    private List<Integer> distributionRatioList = new ArrayList<Integer>();
    private ArrayList<DistributionRatio> runtimeRatios = new ArrayList();

    public WeightedLoadBalancer(List<Integer> distributionRatios) {
        this.deepCloneDistributionRatios(distributionRatios);
        this.loadRuntimeRatios(distributionRatios);
    }

    protected void deepCloneDistributionRatios(List<Integer> distributionRatios) {
        for (Integer value : distributionRatios) {
            this.distributionRatioList.add(value);
        }
    }

    protected void loadRuntimeRatios(List<Integer> distributionRatios) {
        int position = 0;
        for (Integer value : distributionRatios) {
            this.runtimeRatios.add(new DistributionRatio(position++, value));
        }
    }

    protected void normalizeDistributionListAgainstProcessors(List<Processor> processors) {
        if (processors.size() > this.getDistributionRatioList().size()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Listed Load Balance Processors do not match distributionRatio. Best Effort distribution will be attempted");
                LOG.warn((Object)("Number of Processors: " + processors.size() + ". Number of DistibutionRatioList elements: " + this.getDistributionRatioList().size()));
            }
        } else if (processors.size() < this.getDistributionRatioList().size()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"Listed Load Balance Processors do not match distributionRatio. Best Effort distribution will be attempted");
                LOG.warn((Object)("Number of Processors: " + processors.size() + ". Number of DistibutionRatioList elements: " + this.getDistributionRatioList().size()));
            }
            for (int i = processors.size(); i < this.getDistributionRatioList().size(); ++i) {
                this.getDistributionRatioList().set(i, 0);
                this.getRuntimeRatios().remove(i);
            }
        }
    }

    protected boolean isRuntimeRatiosZeroed() {
        boolean cleared = true;
        for (DistributionRatio runtimeRatio : this.runtimeRatios) {
            if (runtimeRatio.getRuntimeWeight() <= 0) continue;
            cleared = false;
        }
        return cleared;
    }

    protected void resetRuntimeRatios() {
        for (DistributionRatio runtimeRatio : this.runtimeRatios) {
            runtimeRatio.setRuntimeWeight(runtimeRatio.getDistributionWeight());
        }
    }

    public List<Integer> getDistributionRatioList() {
        return this.distributionRatioList;
    }

    public void setDistributionRatioList(List<Integer> distributionRatioList) {
        this.distributionRatioList = distributionRatioList;
    }

    public ArrayList<DistributionRatio> getRuntimeRatios() {
        return this.runtimeRatios;
    }

    public void setRuntimeRatios(ArrayList<DistributionRatio> runtimeRatios) {
        this.runtimeRatios = runtimeRatios;
    }
}

