/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.Message;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.jaxp.BytesSource;
import org.apache.camel.converter.jaxp.StringSource;
import org.apache.camel.util.ObjectHelper;

public final class MessageHelper {
    private MessageHelper() {
    }

    public static String extractBodyAsString(Message message) {
        Object answer;
        if (message == null) {
            return null;
        }
        StreamCache newBody = message.getBody(StreamCache.class);
        if (newBody != null) {
            message.setBody(newBody);
        }
        if ((answer = message.getBody(String.class)) == null) {
            answer = message.getBody();
        }
        if (newBody != null) {
            newBody.reset();
        }
        return answer != null ? answer.toString() : null;
    }

    public static String getBodyTypeName(Message message) {
        if (message == null) {
            return null;
        }
        String answer = ObjectHelper.classCanonicalName(message.getBody());
        if (answer != null && answer.startsWith("java.lang.")) {
            return answer.substring(10);
        }
        return answer;
    }

    public static void resetStreamCache(Message message) {
        if (message == null) {
            return;
        }
        if (message.getBody() instanceof StreamCache) {
            ((StreamCache)message.getBody()).reset();
        }
    }

    public static String getContentType(Message message) {
        return message.getHeader("Content-Type", String.class);
    }

    public static String getContentEncoding(Message message) {
        return message.getHeader("Content-Encoding", String.class);
    }

    public static String extractBodyForLogging(Message message) {
        String body;
        String property;
        String property2;
        Object obj = message.getBody();
        if (obj == null) {
            return "Message: [Body is null]";
        }
        boolean streams = false;
        if (message.getExchange() != null && (property2 = message.getExchange().getContext().getProperties().get("CamelLogDebugStreams")) != null) {
            streams = message.getExchange().getContext().getTypeConverter().convertTo(Boolean.class, property2);
        }
        if (!(obj instanceof StringSource) && !(obj instanceof BytesSource)) {
            if (!streams && obj instanceof StreamSource) {
                return "Message: [Body is instance of java.xml.transform.StreamSource]";
            }
            if (!streams && obj instanceof InputStream) {
                return "Message: [Body is instance of java.io.InputStream]";
            }
            if (!streams && obj instanceof OutputStream) {
                return "Message: [Body is instance of java.io.OutputStream]";
            }
            if (!streams && obj instanceof Reader) {
                return "Message: [Body is instance of java.io.Reader]";
            }
            if (!streams && obj instanceof Writer) {
                return "Message: [Body is instance of java.io.Writer]";
            }
        }
        int length = 1000;
        if (message.getExchange() != null && (property = message.getExchange().getContext().getProperties().get("CamelLogDebugBodyMaxChars")) != null) {
            length = message.getExchange().getContext().getTypeConverter().convertTo(Integer.class, property);
        }
        if ((body = obj.toString()) == null) {
            return "Message: [Body is null]";
        }
        if (length > 0 && body.length() > length) {
            body = body.substring(0, length) + "... [Body clipped after " + length + " chars, total length is " + body.length() + "]";
        }
        return "Message: " + body;
    }
}

