/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.deployment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.backend.deployment.DeploymentConfig;
import org.uberfire.backend.deployment.DeploymentConfigService;
import org.uberfire.backend.server.config.Added;
import org.uberfire.backend.server.config.ConfigGroup;
import org.uberfire.backend.server.config.ConfigType;
import org.uberfire.backend.server.config.ConfigurationFactory;
import org.uberfire.backend.server.config.ConfigurationService;
import org.uberfire.backend.server.config.Removed;
import org.uberfire.backend.server.config.SystemRepositoryChangedEvent;
import org.uberfire.backend.server.deployment.DeploymentConfigChangedEvent;
import org.uberfire.backend.server.deployment.DeploymentConfigFactory;

@ApplicationScoped
public class DeploymentConfigServiceImpl
implements DeploymentConfigService {
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ConfigurationFactory configurationFactory;
    @Inject
    private DeploymentConfigFactory deploymentFactory;
    @Inject
    @Added
    private Event<DeploymentConfigChangedEvent> addedDeploymentEvent;
    @Inject
    @Removed
    private Event<DeploymentConfigChangedEvent> removedDeploymentEvent;
    private Map<String, DeploymentConfig> registeredDeployments = new ConcurrentHashMap<String, DeploymentConfig>();

    @PostConstruct
    public void loadGroups() {
        List deployments = this.configurationService.getConfiguration(ConfigType.DEPLOYMENT);
        if (deployments != null) {
            for (ConfigGroup deploymentConfig : deployments) {
                DeploymentConfig deployment = this.deploymentFactory.newDeployment(deploymentConfig);
                this.registeredDeployments.put(deployment.getIdentifier(), deployment);
            }
        }
    }

    public void addDeployment(String identifier, Object deploymentUnit) {
        ConfigGroup deploymentConfig = this.configurationFactory.newConfigGroup(ConfigType.DEPLOYMENT, identifier, "");
        deploymentConfig.addConfigItem(this.configurationFactory.newConfigItem("unit", deploymentUnit));
        this.configurationService.addConfiguration(deploymentConfig);
        DeploymentConfig deployment = this.deploymentFactory.newDeployment(deploymentConfig);
        this.registeredDeployments.put(deployment.getIdentifier(), deployment);
    }

    public void removeDeployment(String identifier) {
        ConfigGroup deploymentConfig = this.configurationFactory.newConfigGroup(ConfigType.DEPLOYMENT, identifier, "");
        this.configurationService.removeConfiguration(deploymentConfig);
        this.registeredDeployments.remove(identifier);
    }

    public DeploymentConfig getDeployment(String identifier) {
        return this.registeredDeployments.get(identifier);
    }

    public Collection<DeploymentConfig> getDeployments() {
        return Collections.unmodifiableCollection(this.registeredDeployments.values());
    }

    public void updateRegisteredDeployments(@Observes SystemRepositoryChangedEvent changedEvent) {
        List deployments = this.configurationService.getConfiguration(ConfigType.DEPLOYMENT);
        if (deployments != null) {
            DeploymentConfig deployment;
            ArrayList<String> processedDeployments = new ArrayList<String>();
            for (ConfigGroup deploymentConfig : deployments) {
                String name = deploymentConfig.getName();
                if (!this.registeredDeployments.containsKey(name)) {
                    deployment = this.deploymentFactory.newDeployment(deploymentConfig);
                    this.addedDeploymentEvent.fire((Object)new DeploymentConfigChangedEvent(deployment.getDeploymentUnit()));
                    this.registeredDeployments.put(deployment.getIdentifier(), deployment);
                }
                processedDeployments.add(name);
            }
            Set<String> registeredDeploymedIds = this.registeredDeployments.keySet();
            for (String identifier : registeredDeploymedIds) {
                if (processedDeployments.contains(identifier)) continue;
                deployment = this.registeredDeployments.remove(identifier);
                this.removedDeploymentEvent.fire((Object)new DeploymentConfigChangedEvent(deployment.getDeploymentUnit()));
            }
        }
    }
}

