/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.binding;

import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.binding.BindingConsumerProcessor;
import org.apache.camel.component.binding.BindingProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Binding;
import org.apache.camel.spi.HasBinding;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ServiceHelper;

public class BindingEndpoint
extends DefaultEndpoint
implements HasBinding {
    private final Binding binding;
    private final Endpoint delegate;

    public BindingEndpoint(String uri, Component component, Binding binding, Endpoint delegate) {
        super(uri, component);
        this.binding = binding;
        this.delegate = delegate;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new BindingProducer(this);
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        BindingConsumerProcessor bindingProcessor = new BindingConsumerProcessor(this, processor);
        return this.delegate.createConsumer(bindingProcessor);
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    public Endpoint getDelegate() {
        return this.delegate;
    }

    public void pipelineBindingProcessor(Processor bindingProcessor, Exchange exchange, Processor delegateProcessor) throws Exception {
        Exchange bindingExchange = exchange;
        bindingProcessor.process(bindingExchange);
        Exchange delegateExchange = this.createNextExchange(bindingExchange);
        ExchangeHelper.copyResults(bindingExchange, delegateExchange);
        delegateProcessor.process(delegateExchange);
    }

    protected Exchange createNextExchange(Exchange previousExchange) {
        Exchange answer = previousExchange;
        if (answer.hasOut()) {
            answer.setIn(answer.getOut());
            answer.setOut(null);
        }
        return answer;
    }

    @Override
    protected void doStart() throws Exception {
        if (this.binding instanceof CamelContextAware) {
            ((CamelContextAware)((Object)this.binding)).setCamelContext(this.getCamelContext());
        }
        ServiceHelper.startServices(this.delegate, this.binding);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopServices(this.delegate, this.binding);
        super.doStop();
    }
}

