/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.protocols.FORWARD_TO_COORD;
import org.jgroups.protocols.relay.CanBeSiteMaster;
import org.jgroups.protocols.relay.CanBeSiteMasterTopology;
import org.jgroups.protocols.relay.Relayer;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.stack.Protocol;
import org.jgroups.util.TopologyUUID;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="RELAY2 protocol")
public class RELAY2
extends Protocol {
    @Property(description="Name of the site (needs to be defined in the configuration)", writable=false)
    protected String site;
    @Property(description="Name of the relay configuration", writable=false)
    protected String config;
    @Property(description="Whether or not this node can become the site master. If false, and we become the coordinator, we won't start the bridge(s)", writable=false)
    protected boolean can_become_site_master = true;
    @Property(description="Whether or not we generate our own addresses in which we use can_become_site_master. If this property is false, can_become_site_master is ignored")
    protected boolean enable_address_tagging = true;
    @Property(description="Whether or not to relay multicast (dest=null) messages")
    protected boolean relay_multicasts = true;
    @Property(description="The number of tries to forward a message to a remote site")
    protected int max_forward_attempts = 5;
    @Property(description="The time (in milliseconds) to sleep between forward attempts")
    protected long forward_sleep = 1000L;
    @ManagedAttribute(description="My site-ID")
    protected short site_id = (short)-1;
    protected final Map<String, RelayConfig.SiteConfig> sites = new HashMap<String, RelayConfig.SiteConfig>();
    protected RelayConfig.SiteConfig site_config;
    @ManagedAttribute(description="Whether this member is the coordinator")
    protected volatile boolean is_coord = false;
    protected volatile Address coord;
    protected Relayer relayer;
    protected volatile Address local_addr;
    @ManagedAttribute(description="FORWARD_TO_COORD protocol is present below the current protocol")
    protected boolean forwarding_protocol_present;

    public RELAY2 site(String site_name) {
        this.site = site_name;
        return this;
    }

    public RELAY2 config(String cfg) {
        this.config = cfg;
        return this;
    }

    public RELAY2 canBecomeSiteMaster(boolean flag) {
        this.can_become_site_master = flag;
        return this;
    }

    public RELAY2 enableAddressTagging(boolean flag) {
        this.enable_address_tagging = flag;
        return this;
    }

    public RELAY2 relayMulticasts(boolean flag) {
        this.relay_multicasts = flag;
        return this;
    }

    public RELAY2 maxForwardAttempts(int num) {
        this.max_forward_attempts = num;
        return this;
    }

    public RELAY2 forwardSleep(long time) {
        this.forward_sleep = time;
        return this;
    }

    public RELAY2 addSite(String site_name, RelayConfig.SiteConfig cfg) {
        this.sites.put(site_name, cfg);
        return this;
    }

    public View getBridgeView(String cluster_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getBridgeView(cluster_name) : null;
    }

    @Override
    public void init() throws Exception {
        List<Integer> available_down_services;
        super.init();
        if (this.site == null) {
            throw new IllegalArgumentException("site cannot be null");
        }
        if (this.config != null) {
            this.parseSiteConfiguration(this.sites);
        }
        for (RelayConfig.SiteConfig cfg : this.sites.values()) {
            SiteUUID.addToCache(cfg.getId(), cfg.getName());
        }
        this.site_config = this.sites.get(this.site);
        if (this.site_config == null) {
            throw new Exception("site configuration for \"" + this.site + "\" not found in " + this.config);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("site configuration:\n" + this.site_config);
        }
        TreeSet<Short> site_ids = new TreeSet<Short>();
        for (RelayConfig.SiteConfig cfg : this.sites.values()) {
            site_ids.add(cfg.getId());
            if (!this.site.equals(cfg.getName())) continue;
            this.site_id = cfg.getId();
        }
        int index = 0;
        Iterator i$ = site_ids.iterator();
        while (i$.hasNext()) {
            int tmp_id = ((Short)i$.next()).shortValue();
            if (tmp_id != index) {
                throw new Exception("site IDs need to start with 0 and are required to increase monotonically; site IDs=" + site_ids);
            }
            ++index;
        }
        if (this.site_id < 0) {
            throw new IllegalArgumentException("site_id could not be determined from site \"" + this.site + "\"");
        }
        if (!this.site_config.getForwards().isEmpty()) {
            this.log.warn("Forwarding routes are currently not supported and will be ignored. This will change with hierarchical routing (https://issues.jboss.org/browse/JGRP-1506)");
        }
        boolean bl = this.forwarding_protocol_present = (available_down_services = this.getDownServices()) != null && available_down_services.contains(105);
        if (!this.forwarding_protocol_present && this.log.isWarnEnabled()) {
            this.log.warn(FORWARD_TO_COORD.class.getSimpleName() + " protocol not found below; " + "unable to re-submit messages to the new coordinator if the current coordinator crashes");
        }
        if (this.enable_address_tagging) {
            JChannel ch = this.getProtocolStack().getChannel();
            final AddressGenerator old_generator = ch.getAddressGenerator();
            ch.setAddressGenerator(new AddressGenerator(){

                @Override
                public Address generateAddress() {
                    if (old_generator != null) {
                        Address addr = old_generator.generateAddress();
                        if (addr instanceof TopologyUUID) {
                            return new CanBeSiteMasterTopology((TopologyUUID)addr, RELAY2.this.can_become_site_master);
                        }
                        if (addr instanceof UUID) {
                            return new CanBeSiteMaster((UUID)addr, RELAY2.this.can_become_site_master);
                        }
                        RELAY2.this.log.warn("address generator is already set (" + old_generator + "); will replace it with own generator");
                    }
                    return CanBeSiteMaster.randomUUID(RELAY2.this.can_become_site_master);
                }
            });
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.is_coord = false;
        if (this.log.isTraceEnabled()) {
            this.log.trace("I ceased to be site master; closing bridges");
        }
        if (this.relayer != null) {
            this.relayer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseSiteConfiguration(Map<String, RelayConfig.SiteConfig> map) throws Exception {
        InputStream input = null;
        try {
            input = ConfiguratorFactory.getConfigStream(this.config);
            RelayConfig.parse(input, map);
        }
        finally {
            Util.close(input);
        }
    }

    @ManagedOperation(description="Prints the contents of the routing table. Only available if we're the current coordinator (site master)")
    public String printRoutes() {
        return this.relayer != null ? this.relayer.printRoutes() : "n/a (not site master)";
    }

    public JChannel getBridge(String site_name) {
        Relayer tmp = this.relayer;
        Relayer.Route route = tmp != null ? tmp.getRoute(SiteUUID.getSite(site_name)) : null;
        return route != null ? route.getBridge() : null;
    }

    public Relayer.Route getRoute(String site_name) {
        Relayer tmp = this.relayer;
        return tmp != null ? tmp.getRoute(SiteUUID.getSite(site_name)) : null;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest == null || !(dest instanceof SiteAddress)) break;
                SiteAddress target = (SiteAddress)dest;
                byte[] buf = this.marshal(msg);
                if (buf == null) {
                    return null;
                }
                Address src = msg.getSrc();
                SiteUUID sender = src instanceof SiteMaster ? new SiteMaster(((SiteMaster)src).getSite()) : new SiteUUID((UUID)this.local_addr, UUID.get(this.local_addr), this.site_id);
                if (target.getSite() == this.site_id) {
                    if (this.local_addr.equals(target) || target instanceof SiteMaster && this.is_coord) {
                        this.deliver(target, sender, buf);
                    } else {
                        this.deliverLocally(target, sender, buf);
                    }
                    return null;
                }
                if (!this.is_coord) {
                    this.forwardTo(this.coord, target, sender, buf, true);
                } else {
                    this.route(target, sender, buf);
                }
                return null;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Relay2Header hdr = (Relay2Header)msg.getHeader(this.id);
                Address dest = msg.getDest();
                if (hdr == null) {
                    if (dest != null || !this.is_coord || !this.relay_multicasts || msg.isFlagSet(Message.Flag.NO_RELAY)) break;
                    byte[] buf = this.marshal(msg);
                    SiteUUID sender = new SiteUUID((UUID)msg.getSrc(), UUID.get(msg.getSrc()), this.site_id);
                    this.sendToBridges(sender, buf, this.site_id);
                    break;
                }
                if (dest != null) {
                    this.handleMessage(hdr, msg);
                } else {
                    this.deliver(null, hdr.original_sender, msg.getBuffer());
                }
                return null;
            }
            case 6: {
                this.handleView((View)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    protected void handleRelayMessage(Relay2Header hdr, Message msg) {
        Address final_dest = hdr.final_dest;
        if (final_dest != null) {
            this.handleMessage(hdr, msg);
        } else {
            Message copy = msg.copy(true, false);
            copy.setDest(null);
            copy.setSrc(null);
            copy.putHeader(this.id, hdr);
            this.down_prot.down(new Event(1, copy));
        }
    }

    protected void handleMessage(Relay2Header hdr, Message msg) {
        switch (hdr.type) {
            case 1: {
                this.route((SiteAddress)hdr.final_dest, (SiteAddress)hdr.original_sender, msg.getBuffer());
                break;
            }
            case 2: {
                this.up_prot.up(new Event(104, hdr.final_dest));
                break;
            }
            case 3: {
                break;
            }
            default: {
                this.log.error("type " + hdr.type + " unknown");
            }
        }
    }

    protected void route(SiteAddress dest, SiteAddress sender, byte[] buf) {
        short target_site = dest.getSite();
        if (target_site == this.site_id) {
            if (this.local_addr.equals(dest) || dest instanceof SiteMaster && this.is_coord) {
                this.deliver(dest, sender, buf);
            } else {
                this.deliverLocally(dest, sender, buf);
            }
            return;
        }
        Relayer tmp = this.relayer;
        if (tmp == null) {
            this.log.warn("not site master; dropping message");
            return;
        }
        Relayer.Route route = null;
        int num_forward_attempts = 0;
        while ((route = tmp.getRoute(target_site)) == null && !Thread.currentThread().isInterrupted() && ++num_forward_attempts < this.max_forward_attempts) {
            Util.sleep(this.forward_sleep);
        }
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        if (route == null) {
            this.log.warn("route for " + SiteUUID.getSiteName(target_site) + " (" + target_site + ") not found, dropping message to " + dest + " from " + sender);
            this.sendSiteUnreachableTo(sender, target_site);
        } else {
            this._route(dest, sender, route, buf);
        }
    }

    protected void sendToBridges(Address sender, byte[] buf, short ... excluded_sites) {
        List<Relayer.Route> routes;
        List<Relayer.Route> list = routes = this.relayer != null ? this.relayer.getRoutes(excluded_sites) : null;
        if (routes == null) {
            return;
        }
        for (Relayer.Route route : routes) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("relaying multicast message from " + sender + " over bridge " + route.site_master.toString());
            }
            Relay2Header hdr = new Relay2Header(1, null, sender);
            Message msg = new Message(route.site_master, buf);
            msg.putHeader(this.id, hdr);
            try {
                route.bridge.send(msg);
            }
            catch (Exception e) {
                this.log.error("failed relaying message from " + sender + " over bridge " + route.site_master.toString());
            }
        }
    }

    protected void sendSiteUnreachableTo(SiteAddress dest, short target_site) {
        Message msg = new Message(dest);
        msg.setSrc(new SiteUUID((UUID)this.local_addr, UUID.get(this.local_addr), this.site_id));
        Relay2Header hdr = new Relay2Header(2, new SiteMaster(target_site), null);
        msg.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, msg));
    }

    protected void forwardTo(Address next_dest, SiteAddress final_dest, Address original_sender, byte[] buf, boolean forward_to_current_coord) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("forwarding message to final destination " + final_dest + " to " + (forward_to_current_coord ? " the current coordinator" : next_dest));
        }
        Message msg = new Message(next_dest, buf);
        Relay2Header hdr = new Relay2Header(1, final_dest, original_sender);
        msg.putHeader(this.id, hdr);
        if (forward_to_current_coord && this.forwarding_protocol_present) {
            this.down_prot.down(new Event(105, msg));
        } else {
            this.down_prot.down(new Event(1, msg));
        }
    }

    protected void deliverLocally(SiteAddress dest, SiteAddress sender, byte[] buf) {
        Address local_dest;
        boolean send_to_coord = false;
        if (dest instanceof SiteUUID) {
            if (dest instanceof SiteMaster) {
                local_dest = this.coord;
                send_to_coord = true;
            } else {
                SiteUUID tmp = (SiteUUID)dest;
                local_dest = new UUID(tmp.getMostSignificantBits(), tmp.getLeastSignificantBits());
            }
        } else {
            local_dest = dest;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("delivering message to " + dest + " in local cluster");
        }
        this.forwardTo(local_dest, dest, sender, buf, send_to_coord);
    }

    protected void deliver(Address dest, Address sender, byte[] buf) {
        try {
            Message original_msg = (Message)Util.streamableFromByteBuffer(Message.class, buf);
            original_msg.setSrc(sender);
            original_msg.setDest(dest);
            if (this.log.isTraceEnabled()) {
                this.log.trace("delivering message from " + sender);
            }
            this.up_prot.up(new Event(1, original_msg));
        }
        catch (Exception e) {
            this.log.error("failed unmarshalling message", e);
        }
    }

    protected void _route(SiteAddress to, SiteAddress from, Relayer.Route route, byte[] buf) {
        if (route == null) {
            this.log.warn("route for site" + to.getSite() + " not found; dropping message");
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("routing message to " + to + " via " + route.site_master);
        }
        Relay2Header hdr = new Relay2Header(1, to, from);
        Message msg = new Message(route.site_master, buf);
        msg.putHeader(this.id, hdr);
        try {
            route.bridge.send(msg);
        }
        catch (Exception e) {
            this.log.error("failure relaying message", e);
        }
    }

    protected byte[] marshal(Message msg) {
        Message tmp = msg.copy(true, (short)200);
        tmp.setDest(null);
        tmp.setSrc(null);
        try {
            return Util.streamableToByteBuffer(tmp);
        }
        catch (Exception e) {
            this.log.error("marshalling failure", e);
            return null;
        }
    }

    protected void handleView(View view) {
        Address old_coord = this.coord;
        Address new_coord = RELAY2.determineSiteMaster(view);
        boolean become_coord = new_coord.equals(this.local_addr) && (old_coord == null || !old_coord.equals(this.local_addr));
        boolean cease_coord = old_coord != null && old_coord.equals(this.local_addr) && !new_coord.equals(this.local_addr);
        this.coord = new_coord;
        if (become_coord) {
            this.is_coord = true;
            String bridge_name = "_" + UUID.get(this.local_addr);
            this.relayer = new Relayer(this, this.log);
            try {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("I became site master; starting bridges");
                }
                this.relayer.start(this.site_config.getBridges(), bridge_name, this.site_id);
            }
            catch (Throwable t) {
                this.log.error("failed starting relayer", t);
            }
        } else if (cease_coord) {
            this.is_coord = false;
            if (this.log.isTraceEnabled()) {
                this.log.trace("I ceased to be site master; closing bridges");
            }
            if (this.relayer != null) {
                this.relayer.stop();
            }
        }
    }

    protected static Address determineSiteMaster(View view) {
        List<Address> members = view.getMembers();
        for (Address member : members) {
            if ((!(member instanceof CanBeSiteMasterTopology) || !((CanBeSiteMasterTopology)member).canBecomeSiteMaster()) && (!(member instanceof CanBeSiteMaster) || !((CanBeSiteMaster)member).canBecomeSiteMaster())) continue;
            return member;
        }
        return Util.getCoordinator(view);
    }

    public static class Relay2Header
    extends Header {
        public static final byte DATA = 1;
        public static final byte SITE_UNREACHABLE = 2;
        public static final byte HOST_UNREACHABLE = 3;
        protected byte type;
        protected Address final_dest;
        protected Address original_sender;

        public Relay2Header() {
        }

        public Relay2Header(byte type, Address final_dest, Address original_sender) {
            this.type = type;
            this.final_dest = final_dest;
            this.original_sender = original_sender;
        }

        @Override
        public int size() {
            return 1 + Util.size(this.final_dest) + Util.size(this.original_sender);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeAddress(this.final_dest, out);
            Util.writeAddress(this.original_sender, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.final_dest = Util.readAddress(in);
            this.original_sender = Util.readAddress(in);
        }

        @Override
        public String toString() {
            return Relay2Header.typeToString(this.type) + " [dest=" + this.final_dest + ", sender=" + this.original_sender + "]";
        }

        protected static String typeToString(byte type) {
            switch (type) {
                case 1: {
                    return "DATA";
                }
                case 2: {
                    return "SITE_UNREACHABLE";
                }
                case 3: {
                    return "HOST_UNREACHABLE";
                }
            }
            return "<unknown>";
        }
    }
}

