/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramChannelFactory;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioDatagramPipelineSink;
import io.netty.channel.socket.nio.SelectorUtil;
import io.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;

public class NioDatagramChannelFactory
implements DatagramChannelFactory {
    private final Executor workerExecutor;
    private final NioDatagramPipelineSink sink;

    public NioDatagramChannelFactory(Executor workerExecutor) {
        this(workerExecutor, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public NioDatagramChannelFactory(Executor workerExecutor, int workerCount) {
        if (workerCount <= 0) {
            throw new IllegalArgumentException(String.format("workerCount (%s) must be a positive integer.", workerCount));
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor argument must not be null");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new NioDatagramPipelineSink(workerExecutor, workerCount);
    }

    @Override
    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return NioDatagramChannel.create(this, pipeline, this.sink, this.sink.nextWorker());
    }

    @Override
    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.workerExecutor);
    }
}

