/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramChannelFactory;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioDatagramPipelineSink;
import io.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;

public class OioDatagramChannelFactory
implements DatagramChannelFactory {
    private final Executor workerExecutor;
    final OioDatagramPipelineSink sink;

    public OioDatagramChannelFactory(Executor workerExecutor) {
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        this.workerExecutor = workerExecutor;
        this.sink = new OioDatagramPipelineSink(workerExecutor);
    }

    @Override
    public DatagramChannel newChannel(ChannelPipeline pipeline) {
        return OioDatagramChannel.create(this, pipeline, this.sink);
    }

    @Override
    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.workerExecutor);
    }
}

