/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.oio;

import io.netty.channel.AbstractChannelSink;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelState;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioDatagramWorker;
import io.netty.util.internal.DeadLockProofWorker;
import java.net.SocketAddress;
import java.util.concurrent.Executor;

class OioDatagramPipelineSink
extends AbstractChannelSink {
    private final Executor workerExecutor;

    OioDatagramPipelineSink(Executor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    @Override
    public void eventSunk(ChannelPipeline pipeline, ChannelEvent e) throws Exception {
        OioDatagramChannel channel = (OioDatagramChannel)e.getChannel();
        ChannelFuture future = e.getFuture();
        if (e instanceof ChannelStateEvent) {
            ChannelStateEvent stateEvent = (ChannelStateEvent)e;
            ChannelState state = stateEvent.getState();
            Object value = stateEvent.getValue();
            switch (state) {
                case OPEN: {
                    if (!Boolean.FALSE.equals(value)) break;
                    OioDatagramWorker.close(channel, future);
                    break;
                }
                case BOUND: {
                    if (value != null) {
                        this.bind(channel, future, (SocketAddress)value);
                        break;
                    }
                    OioDatagramWorker.close(channel, future);
                    break;
                }
                case CONNECTED: {
                    if (value != null) {
                        this.connect(channel, future, (SocketAddress)value);
                        break;
                    }
                    OioDatagramWorker.disconnect(channel, future);
                    break;
                }
                case INTEREST_OPS: {
                    OioDatagramWorker.setInterestOps(channel, future, (Integer)value);
                }
            }
        } else if (e instanceof MessageEvent) {
            MessageEvent evt = (MessageEvent)e;
            OioDatagramWorker.write(channel, future, evt.getMessage(), evt.getRemoteAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bind(OioDatagramChannel channel, ChannelFuture future, SocketAddress localAddress) {
        boolean bound = false;
        boolean workerStarted = false;
        try {
            channel.socket.bind(localAddress);
            bound = true;
            future.setSuccess();
            Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
            DeadLockProofWorker.start(this.workerExecutor, new OioDatagramWorker(channel));
            workerStarted = true;
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
        finally {
            if (bound && !workerStarted) {
                OioDatagramWorker.close(channel, future);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(OioDatagramChannel channel, ChannelFuture future, SocketAddress remoteAddress) {
        boolean bound = channel.isBound();
        boolean connected = false;
        boolean workerStarted = false;
        future.addListener(ChannelFutureListener.CLOSE_ON_FAILURE);
        channel.remoteAddress = null;
        try {
            channel.socket.connect(remoteAddress);
            connected = true;
            future.setSuccess();
            if (!bound) {
                Channels.fireChannelBound(channel, (SocketAddress)channel.getLocalAddress());
            }
            Channels.fireChannelConnected(channel, (SocketAddress)channel.getRemoteAddress());
            if (!bound) {
                DeadLockProofWorker.start(this.workerExecutor, new OioDatagramWorker(channel));
            }
            workerStarted = true;
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
        finally {
            if (connected && !workerStarted) {
                OioDatagramWorker.close(channel, future);
            }
        }
    }
}

