/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.local;

import io.netty.bootstrap.ClientBootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineFactory;
import io.netty.channel.Channels;
import io.netty.channel.local.DefaultLocalClientChannelFactory;
import io.netty.channel.local.DefaultLocalServerChannelFactory;
import io.netty.channel.local.LocalAddress;
import io.netty.example.echo.EchoServerHandler;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.logging.LoggingHandler;
import io.netty.logging.InternalLogLevel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class LocalExample {
    private final String port;

    public LocalExample(String port) {
        this.port = port;
    }

    public void run() throws IOException {
        String line;
        LocalAddress socketAddress = new LocalAddress(this.port);
        ServerBootstrap sb = new ServerBootstrap(new DefaultLocalServerChannelFactory());
        EchoServerHandler handler = new EchoServerHandler();
        sb.getPipeline().addLast("handler", handler);
        sb.bind(socketAddress);
        ClientBootstrap cb = new ClientBootstrap(new DefaultLocalClientChannelFactory());
        cb.setPipelineFactory(new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline(new StringDecoder(), new StringEncoder(), new LoggingHandler(InternalLogLevel.INFO));
            }
        });
        ChannelFuture channelFuture = cb.connect(socketAddress);
        channelFuture.awaitUninterruptibly();
        System.out.println("Enter text (quit to end)");
        ChannelFuture lastWriteFuture = null;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((line = in.readLine()) != null && !"quit".equalsIgnoreCase(line)) {
            lastWriteFuture = channelFuture.getChannel().write(line);
        }
        if (lastWriteFuture != null) {
            lastWriteFuture.awaitUninterruptibly();
        }
        channelFuture.getChannel().close();
        channelFuture.getChannel().getCloseFuture().awaitUninterruptibly();
        cb.releaseExternalResources();
        sb.releaseExternalResources();
    }

    public static void main(String[] args) throws Exception {
        new LocalExample("1").run();
    }
}

