/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.plugin;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletContext;
import org.jboss.errai.bus.server.annotations.Service;
import org.uberfire.backend.plugin.RuntimePluginsService;
import org.uberfire.java.nio.file.DirectoryStream;
import org.uberfire.java.nio.file.Files;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.Paths;

@Service
@ApplicationScoped
public class RuntimePluginsServiceServerImpl
implements RuntimePluginsService {
    @Inject
    @Named(value="uf")
    private ServletContext servletContext;

    public Collection<String> listFramworksContent() {
        return this.directoryContent("frameworks", "*.js");
    }

    public Collection<String> listPluginsContent() {
        return this.directoryContent("plugins", "*.js");
    }

    public String getTemplateContent(String url) {
        Path template = url.startsWith("/") ? Paths.get((URI)URI.create("file://" + this.getRealPath("plugins") + url)) : Paths.get((URI)URI.create("file://" + this.getRealPath("plugins") + "/" + url));
        if (Files.isRegularFile((Path)template, (LinkOption[])new LinkOption[0])) {
            return new String(Files.readAllBytes((Path)template));
        }
        return "";
    }

    private Collection<String> directoryContent(String directory, String glob) {
        ArrayList<String> result = new ArrayList<String>();
        Path pluginsRootPath = Paths.get((URI)URI.create("file://" + this.getRealPath(directory)));
        if (Files.isDirectory((Path)pluginsRootPath, (LinkOption[])new LinkOption[0])) {
            DirectoryStream stream = Files.newDirectoryStream((Path)pluginsRootPath, (String)glob);
            for (Path activeJS : stream) {
                result.add(new String(Files.readAllBytes((Path)activeJS)));
            }
        }
        return result;
    }

    private String getRealPath(String path) {
        return this.servletContext.getRealPath(path).replaceAll("\\\\", "/").replaceAll(" ", "%20");
    }
}

