/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Alternative;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.Subject;
import org.uberfire.security.auth.AuthenticationException;
import org.uberfire.security.auth.AuthenticationManager;
import org.uberfire.security.auth.AuthenticationResult;
import org.uberfire.security.auth.AuthenticationScheme;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.auth.AuthenticationStatus;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.auth.RoleProvider;
import org.uberfire.security.auth.SubjectPropertiesProvider;
import org.uberfire.security.impl.IdentityImpl;
import org.uberfire.security.server.UserPassSecurityContext;
import org.uberfire.security.server.auth.DefaultAuthenticationProvider;

@Alternative
public class SimpleUserPassAuthenticationManager
implements AuthenticationManager {
    private final AuthenticationScheme scheme;
    private final RoleProvider roleProvider;
    private final SubjectPropertiesProvider propertiesProvider;
    private final DefaultAuthenticationProvider authProvider;

    public SimpleUserPassAuthenticationManager(AuthenticationSource source, AuthenticationScheme scheme, RoleProvider roleProvider, SubjectPropertiesProvider propertiesProvider, Map<String, String> options) {
        this.scheme = scheme;
        this.roleProvider = roleProvider != null ? roleProvider : (source instanceof RoleProvider ? (RoleProvider)source : null);
        this.propertiesProvider = propertiesProvider;
        this.authProvider = new DefaultAuthenticationProvider(source);
        this.authProvider.initialize(options);
    }

    public Subject authenticate(SecurityContext context) throws AuthenticationException {
        UserPassSecurityContext userPassContext = (UserPassSecurityContext)Preconditions.checkInstanceOf((String)"context", (Object)context, UserPassSecurityContext.class);
        Credential credential = this.scheme.buildCredential((SecurityContext)userPassContext);
        if (credential == null) {
            throw new AuthenticationException("Invalid credentials.");
        }
        AuthenticationResult authResult = this.authProvider.authenticate(credential, context);
        final Principal principal = authResult.getStatus().equals((Object)AuthenticationStatus.SUCCESS) ? authResult.getPrincipal() : null;
        if (principal == null) {
            throw new AuthenticationException("Invalid credentials.");
        }
        ArrayList roles = new ArrayList();
        if (this.roleProvider != null) {
            roles.addAll(this.roleProvider.loadRoles(principal));
        }
        HashMap<String, String> properties = new HashMap<String, String>(){
            {
                if (SimpleUserPassAuthenticationManager.this.propertiesProvider != null) {
                    this.putAll(SimpleUserPassAuthenticationManager.this.propertiesProvider.loadProperties(principal));
                }
            }
        };
        return new IdentityImpl(principal.getName(), roles, (Map)properties);
    }

    public void logout(SecurityContext context) throws AuthenticationException {
    }
}

