/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth.source;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.validation.Preconditions;
import org.uberfire.security.Role;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.auth.AuthenticationSource;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.auth.RoleProvider;
import org.uberfire.security.impl.RoleImpl;
import org.uberfire.security.impl.auth.UsernamePasswordCredential;

public abstract class AbstractDatabaseAuthSource
implements AuthenticationSource,
RoleProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDatabaseAuthSource.class);
    private boolean alreadyInit = false;
    private String userQuery;
    private String rolesQuery;

    public abstract Connection getConnection();

    public synchronized void initialize(Map<String, ?> options) {
        if (!this.alreadyInit) {
            this.userQuery = "select 1 from " + options.get("userTable") + " where " + options.get("userField") + "=? and " + options.get("passwordField") + "=?";
            if (options.containsKey("userQuery")) {
                this.userQuery = (String)options.get("userQuery");
            }
            LOG.debug("userQuery = " + this.userQuery);
            this.rolesQuery = "select " + options.get("userRoleRoleField") + " from " + options.get("userRoleTable") + " where " + options.get("userRoleUserField") + "=?";
            if (options.containsKey("rolesQuery")) {
                this.rolesQuery = (String)options.get("rolesQuery");
            }
            LOG.debug("rolesQuery = " + this.rolesQuery);
            this.alreadyInit = true;
        }
    }

    public boolean supportsCredential(Credential credential) {
        if (credential == null) {
            return false;
        }
        return credential instanceof UsernamePasswordCredential;
    }

    public boolean authenticate(Credential credential, SecurityContext securityContext) {
        UsernamePasswordCredential usernamePasswd = (UsernamePasswordCredential)Preconditions.checkInstanceOf((String)"credential", (Object)credential, UsernamePasswordCredential.class);
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement statement = connection.prepareStatement(this.userQuery);
            statement.setString(1, usernamePasswd.getUserName());
            statement.setObject(2, usernamePasswd.getPassword());
            ResultSet queryResult = statement.executeQuery();
            boolean result = queryResult.next();
            queryResult.close();
            statement.close();
            boolean bl = result;
            return bl;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    public List<Role> loadRoles(Principal principal) {
        Connection connection = null;
        try {
            connection = this.getConnection();
            PreparedStatement statement = connection.prepareStatement(this.rolesQuery);
            statement.setString(1, principal.getName());
            ResultSet queryResult = statement.executeQuery();
            ArrayList<Role> roles = new ArrayList<Role>();
            while (queryResult.next()) {
                String roleName = queryResult.getString(1);
                roles.add((Role)new RoleImpl(roleName));
            }
            queryResult.close();
            statement.close();
            ArrayList<Role> arrayList = roles;
            return arrayList;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }
}

