/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZkAsyncCallbacks {
    private static Logger LOG = Logger.getLogger(ZkAsyncCallbacks.class);

    static abstract class DefaultCallback {
        AtomicBoolean _lock = new AtomicBoolean(false);
        int _rc = -1;

        DefaultCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(int rc, String path, Object ctx) {
            if (rc != 0) {
                LOG.warn((Object)(this + ", rc:" + KeeperException.Code.get((int)rc) + ", path: " + path));
            }
            this._rc = rc;
            this.handle();
            AtomicBoolean atomicBoolean = this._lock;
            synchronized (atomicBoolean) {
                this._lock.set(true);
                this._lock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitForSuccess() {
            try {
                AtomicBoolean atomicBoolean = this._lock;
                synchronized (atomicBoolean) {
                    while (!this._lock.get()) {
                        this._lock.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Interrupted waiting for success", (Throwable)e);
            }
            return true;
        }

        public int getRc() {
            return this._rc;
        }

        public abstract void handle();
    }

    static class DeleteCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.VoidCallback {
        DeleteCallbackHandler() {
        }

        public void processResult(int rc, String path, Object ctx) {
            this.callback(rc, path, ctx);
        }

        @Override
        public void handle() {
        }
    }

    static class CreateCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.StringCallback {
        CreateCallbackHandler() {
        }

        public void processResult(int rc, String path, Object ctx, String name) {
            this.callback(rc, path, ctx);
        }

        @Override
        public void handle() {
        }
    }

    static class ExistsCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.StatCallback {
        Stat _stat;

        ExistsCallbackHandler() {
        }

        @Override
        public void handle() {
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            if (rc == 0) {
                this._stat = stat;
            }
            this.callback(rc, path, ctx);
        }
    }

    static class SetDataCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.StatCallback {
        Stat _stat;

        SetDataCallbackHandler() {
        }

        @Override
        public void handle() {
        }

        public void processResult(int rc, String path, Object ctx, Stat stat) {
            if (rc == 0) {
                this._stat = stat;
            }
            this.callback(rc, path, ctx);
        }

        public Stat getStat() {
            return this._stat;
        }
    }

    static class GetDataCallbackHandler
    extends DefaultCallback
    implements AsyncCallback.DataCallback {
        byte[] _data;
        Stat _stat;

        GetDataCallbackHandler() {
        }

        @Override
        public void handle() {
        }

        public void processResult(int rc, String path, Object ctx, byte[] data, Stat stat) {
            if (rc == 0) {
                this._data = data;
                this._stat = stat;
            }
            this.callback(rc, path, ctx);
        }
    }
}

