/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.direct.DirectConsumerNotAvailableException;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectBlockingProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(DirectBlockingProducer.class);
    private final DirectEndpoint endpoint;

    public DirectBlockingProducer(DirectEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.getConsumer(exchange).getProcessor().process(exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            return this.getConsumer(exchange).getAsyncProcessor().process(exchange, callback);
        }
        catch (Exception e) {
            exchange.setException(e);
            callback.done(true);
            return true;
        }
    }

    protected DirectConsumer getConsumer(Exchange exchange) throws Exception {
        DirectConsumer answer = this.endpoint.getConsumer();
        if (answer == null && (answer = this.awaitConsumer()) == null) {
            LOG.warn("No consumers available on endpoint: " + this.endpoint + " to process: " + exchange);
            throw new DirectConsumerNotAvailableException("No consumers available on endpoint: " + this.endpoint, exchange);
        }
        return answer;
    }

    private DirectConsumer awaitConsumer() throws InterruptedException {
        DirectConsumer answer = null;
        StopWatch watch = new StopWatch();
        boolean done = false;
        while (!done) {
            Thread.sleep(500L);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Waited {} for consumer to be ready", (Object)watch.taken());
            }
            if ((answer = this.endpoint.getConsumer()) != null) {
                return answer;
            }
            done = watch.taken() >= this.endpoint.getTimeout();
        }
        return answer;
    }
}

