/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp;

import com.sun.nio.sctp.AbstractNotificationHandler;
import com.sun.nio.sctp.AssociationChangeNotification;
import com.sun.nio.sctp.HandlerResult;
import com.sun.nio.sctp.Notification;
import com.sun.nio.sctp.PeerAddressChangeNotification;
import com.sun.nio.sctp.SendFailedNotification;
import com.sun.nio.sctp.ShutdownNotification;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.Channels;
import io.netty.channel.sctp.SctpChannelImpl;
import io.netty.channel.sctp.SctpNotificationEvent;

class SctpNotificationHandler
extends AbstractNotificationHandler {
    private final SctpChannelImpl sctpChannel;
    private final ChannelPipeline pipeline;

    SctpNotificationHandler(SctpChannelImpl sctpChannel) {
        this.sctpChannel = sctpChannel;
        this.pipeline = sctpChannel.getPipeline();
    }

    public HandlerResult handleNotification(AssociationChangeNotification notification, Object o) {
        this.fireNotificationReceived(notification, o);
        return HandlerResult.CONTINUE;
    }

    public HandlerResult handleNotification(PeerAddressChangeNotification notification, Object o) {
        this.fireNotificationReceived(notification, o);
        return HandlerResult.CONTINUE;
    }

    public HandlerResult handleNotification(SendFailedNotification notification, Object o) {
        this.fireNotificationReceived(notification, o);
        return HandlerResult.CONTINUE;
    }

    public HandlerResult handleNotification(ShutdownNotification notification, Object o) {
        Channels.fireChannelDisconnected(this.sctpChannel);
        return HandlerResult.RETURN;
    }

    private void fireNotificationReceived(Notification notification, Object o) {
        this.pipeline.sendUpstream(new SctpNotificationEvent(this.sctpChannel, notification, o));
    }
}

