/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.sctp;

import com.sun.nio.sctp.MessageInfo;
import com.sun.nio.sctp.SctpChannel;
import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBufferFactory;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;
import io.netty.channel.ReceiveBufferSizePredictor;
import io.netty.channel.sctp.SctpAcceptedChannel;
import io.netty.channel.sctp.SctpChannelImpl;
import io.netty.channel.sctp.SctpClientChannel;
import io.netty.channel.sctp.SctpFrame;
import io.netty.channel.sctp.SctpNotificationHandler;
import io.netty.channel.sctp.SctpProviderMetadata;
import io.netty.channel.sctp.SctpReceiveBufferPool;
import io.netty.channel.sctp.SctpSendBufferPool;
import io.netty.channel.sctp.SelectorUtil;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.internal.DeadLockProofWorker;
import io.netty.util.internal.QueueFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class SctpWorker
implements Runnable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SctpWorker.class);
    private static final int CONSTRAINT_LEVEL = SctpProviderMetadata.CONSTRAINT_LEVEL;
    static final int CLEANUP_INTERVAL = 256;
    private final Executor executor;
    private boolean started;
    private volatile Thread thread;
    volatile Selector selector;
    private final AtomicBoolean wakenUp = new AtomicBoolean();
    private final ReadWriteLock selectorGuard = new ReentrantReadWriteLock();
    private final Object startStopLock = new Object();
    private final Queue<Runnable> registerTaskQueue = QueueFactory.createQueue(Runnable.class);
    private final Queue<Runnable> writeTaskQueue = QueueFactory.createQueue(Runnable.class);
    private volatile int cancelledKeys;
    private final SctpReceiveBufferPool recvBufferPool = new SctpReceiveBufferPool();
    private final SctpSendBufferPool sendBufferPool = new SctpSendBufferPool();
    private SctpNotificationHandler notificationHandler;

    SctpWorker(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(SctpChannelImpl channel, ChannelFuture future) {
        Selector selector;
        boolean server = !(channel instanceof SctpClientChannel);
        RegisterTask registerTask = new RegisterTask(channel, future, server);
        this.notificationHandler = new SctpNotificationHandler(channel);
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.started) {
                try {
                    this.selector = selector = Selector.open();
                }
                catch (Throwable t) {
                    throw new ChannelException("Failed to create a selector.", t);
                }
                boolean success = false;
                try {
                    DeadLockProofWorker.start(this.executor, this);
                    success = true;
                }
                finally {
                    if (!success) {
                        block17: {
                            try {
                                selector.close();
                            }
                            catch (Throwable t) {
                                if (!logger.isWarnEnabled()) break block17;
                                logger.warn("Failed to close a selector.", t);
                            }
                        }
                        selector = null;
                        this.selector = null;
                    }
                }
            }
            selector = this.selector;
            assert (selector != null && selector.isOpen());
            this.started = true;
            boolean offered = this.registerTaskQueue.offer(registerTask);
            assert (offered);
        }
        if (this.wakenUp.compareAndSet(false, true)) {
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread = Thread.currentThread();
        boolean shutdown = false;
        Selector selector = this.selector;
        while (true) {
            this.wakenUp.set(false);
            if (CONSTRAINT_LEVEL != 0) {
                this.selectorGuard.writeLock().lock();
                this.selectorGuard.writeLock().unlock();
            }
            try {
                SelectorUtil.select(selector);
                if (this.wakenUp.get()) {
                    selector.wakeup();
                }
                this.cancelledKeys = 0;
                this.processRegisterTaskQueue();
                this.processWriteTaskQueue();
                this.processSelectedKeys(selector.selectedKeys());
                if (selector.keys().isEmpty()) {
                    if (shutdown || this.executor instanceof ExecutorService && ((ExecutorService)this.executor).isShutdown()) {
                        Object object = this.startStopLock;
                        synchronized (object) {
                            if (this.registerTaskQueue.isEmpty() && selector.keys().isEmpty()) {
                                this.started = false;
                                try {
                                    selector.close();
                                }
                                catch (IOException e) {
                                    if (logger.isWarnEnabled()) {
                                        logger.warn("Failed to close a selector.", e);
                                    }
                                }
                                finally {
                                    this.selector = null;
                                }
                                break;
                            }
                            shutdown = false;
                            continue;
                        }
                    }
                    shutdown = true;
                    continue;
                }
                shutdown = false;
            }
            catch (Throwable t) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Unexpected exception in the selector loop.", t);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    private void processRegisterTaskQueue() throws IOException {
        Runnable task;
        while ((task = this.registerTaskQueue.poll()) != null) {
            task.run();
            this.cleanUpCancelledKeys();
        }
    }

    private void processWriteTaskQueue() throws IOException {
        Runnable task;
        while ((task = this.writeTaskQueue.poll()) != null) {
            task.run();
            this.cleanUpCancelledKeys();
        }
    }

    private void processSelectedKeys(Set<SelectionKey> selectedKeys) throws IOException {
        Iterator<SelectionKey> i = selectedKeys.iterator();
        while (i.hasNext()) {
            SelectionKey k = i.next();
            i.remove();
            try {
                int readyOps = k.readyOps();
                if (((readyOps & 1) != 0 || readyOps == 0) && !this.read(k)) continue;
                if ((readyOps & 4) != 0) {
                    this.writeFromSelectorLoop(k);
                }
            }
            catch (CancelledKeyException e) {
                this.close(k);
            }
            if (!this.cleanUpCancelledKeys()) continue;
            break;
        }
    }

    private boolean cleanUpCancelledKeys() throws IOException {
        if (this.cancelledKeys >= 256) {
            this.cancelledKeys = 0;
            this.selector.selectNow();
            return true;
        }
        return false;
    }

    private boolean read(SelectionKey k) {
        SctpChannelImpl channel = (SctpChannelImpl)k.attachment();
        ReceiveBufferSizePredictor predictor = channel.getConfig().getReceiveBufferSizePredictor();
        int predictedRecvBufSize = predictor.nextReceiveBufferSize();
        boolean messageReceived = false;
        boolean failure = true;
        MessageInfo messageInfo = null;
        ByteBuffer bb = this.recvBufferPool.acquire(predictedRecvBufSize);
        try {
            messageInfo = channel.channel.receive(bb, null, this.notificationHandler);
            if (messageInfo != null) {
                messageReceived = true;
                if (!messageInfo.isUnordered()) {
                    failure = false;
                } else {
                    if (logger.isErrorEnabled()) {
                        logger.error("Received unordered SCTP Packet");
                    }
                    failure = true;
                }
            } else {
                messageReceived = false;
                failure = false;
            }
        }
        catch (ClosedChannelException e) {
        }
        catch (Throwable t) {
            Channels.fireExceptionCaught(channel, t);
        }
        if (messageReceived) {
            bb.flip();
            ChannelBufferFactory bufferFactory = channel.getConfig().getBufferFactory();
            int receivedBytes = bb.remaining();
            ChannelBuffer buffer = bufferFactory.getBuffer(receivedBytes);
            buffer.setBytes(0, bb);
            buffer.writerIndex(receivedBytes);
            this.recvBufferPool.release(bb);
            predictor.previousReceiveBufferSize(receivedBytes);
            Channels.fireMessageReceived(channel, (Object)new SctpFrame(messageInfo, buffer), messageInfo.address());
        } else {
            this.recvBufferPool.release(bb);
        }
        if (channel.channel.isBlocking() && !messageReceived || failure) {
            k.cancel();
            this.close(channel, Channels.succeededFuture(channel));
            return false;
        }
        return true;
    }

    private void close(SelectionKey k) {
        SctpChannelImpl ch = (SctpChannelImpl)k.attachment();
        this.close(ch, Channels.succeededFuture(ch));
    }

    void writeFromUserCode(SctpChannelImpl channel) {
        if (!channel.isConnected()) {
            this.cleanUpWriteBuffer(channel);
            return;
        }
        if (this.scheduleWriteIfNecessary(channel)) {
            return;
        }
        if (channel.writeSuspended) {
            return;
        }
        if (channel.inWriteNowLoop) {
            return;
        }
        this.write0(channel);
    }

    void writeFromTaskLoop(SctpChannelImpl ch) {
        if (!ch.writeSuspended) {
            this.write0(ch);
        }
    }

    void writeFromSelectorLoop(SelectionKey k) {
        SctpChannelImpl ch = (SctpChannelImpl)k.attachment();
        ch.writeSuspended = false;
        this.write0(ch);
    }

    private boolean scheduleWriteIfNecessary(SctpChannelImpl channel) {
        Thread workerThread;
        Thread currentThread = Thread.currentThread();
        if (currentThread != (workerThread = this.thread)) {
            Selector workerSelector;
            if (channel.writeTaskInTaskQueue.compareAndSet(false, true)) {
                boolean offered = this.writeTaskQueue.offer(channel.writeTask);
                assert (offered);
            }
            if ((!(channel instanceof SctpAcceptedChannel) || ((SctpAcceptedChannel)channel).bossThread != currentThread) && (workerSelector = this.selector) != null && this.wakenUp.compareAndSet(false, true)) {
                workerSelector.wakeup();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write0(SctpChannelImpl channel) {
        boolean open = true;
        boolean addOpWrite = false;
        boolean removeOpWrite = false;
        long writtenBytes = 0L;
        SctpSendBufferPool sendBufferPool = this.sendBufferPool;
        SctpChannel ch = channel.channel;
        Queue<MessageEvent> writeBuffer = channel.writeBuffer;
        int writeSpinCount = channel.getConfig().getWriteSpinCount();
        Object object = channel.writeLock;
        synchronized (object) {
            channel.inWriteNowLoop = true;
            while (true) {
                SctpSendBufferPool.SendBuffer buf;
                MessageEvent evt;
                if ((evt = channel.currentWriteEvent) == null) {
                    channel.currentWriteEvent = evt = writeBuffer.poll();
                    if (evt == null) {
                        removeOpWrite = true;
                        channel.writeSuspended = false;
                        break;
                    }
                    channel.currentWriteBuffer = buf = sendBufferPool.acquire(evt.getMessage());
                } else {
                    buf = channel.currentWriteBuffer;
                }
                ChannelFuture future = evt.getFuture();
                try {
                    long localWrittenBytes = 0L;
                    for (int i = writeSpinCount; i > 0; --i) {
                        localWrittenBytes = buf.transferTo(ch);
                        if (localWrittenBytes != 0L) {
                            writtenBytes += localWrittenBytes;
                            break;
                        }
                        if (buf.finished()) break;
                    }
                    if (buf.finished()) {
                        buf.release();
                        channel.currentWriteEvent = null;
                        channel.currentWriteBuffer = null;
                        evt = null;
                        buf = null;
                        future.setSuccess();
                        continue;
                    }
                    addOpWrite = true;
                    channel.writeSuspended = true;
                    if (localWrittenBytes <= 0L) break;
                    future.setProgress(localWrittenBytes, buf.writtenBytes(), buf.totalBytes());
                }
                catch (AsynchronousCloseException e) {
                    continue;
                }
                catch (Throwable t) {
                    buf.release();
                    channel.currentWriteEvent = null;
                    channel.currentWriteBuffer = null;
                    buf = null;
                    evt = null;
                    future.setFailure(t);
                    Channels.fireExceptionCaught(channel, t);
                    if (!(t instanceof IOException)) continue;
                    open = false;
                    this.close(channel, Channels.succeededFuture(channel));
                    continue;
                }
                break;
            }
            channel.inWriteNowLoop = false;
        }
        if (open) {
            if (addOpWrite) {
                this.setOpWrite(channel);
            } else if (removeOpWrite) {
                this.clearOpWrite(channel);
            }
        }
        Channels.fireWriteComplete(channel, writtenBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOpWrite(SctpChannelImpl channel) {
        Selector selector = this.selector;
        SelectionKey key = channel.channel.keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            this.close(key);
            return;
        }
        Object object = channel.interestOpsLock;
        synchronized (object) {
            int interestOps = channel.getRawInterestOps();
            if ((interestOps & 4) == 0) {
                key.interestOps(interestOps |= 4);
                channel.setRawInterestOpsNow(interestOps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearOpWrite(SctpChannelImpl channel) {
        Selector selector = this.selector;
        SelectionKey key = channel.channel.keyFor(selector);
        if (key == null) {
            return;
        }
        if (!key.isValid()) {
            this.close(key);
            return;
        }
        Object object = channel.interestOpsLock;
        synchronized (object) {
            int interestOps = channel.getRawInterestOps();
            if ((interestOps & 4) != 0) {
                key.interestOps(interestOps &= 0xFFFFFFFB);
                channel.setRawInterestOpsNow(interestOps);
            }
        }
    }

    void close(SctpChannelImpl channel, ChannelFuture future) {
        boolean connected = channel.isConnected();
        boolean bound = channel.isBound();
        try {
            channel.channel.close();
            ++this.cancelledKeys;
            if (channel.setClosed()) {
                future.setSuccess();
                if (connected) {
                    Channels.fireChannelDisconnected(channel);
                }
                if (bound) {
                    Channels.fireChannelUnbound(channel);
                }
                this.cleanUpWriteBuffer(channel);
                Channels.fireChannelClosed(channel);
            } else {
                future.setSuccess();
            }
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpWriteBuffer(SctpChannelImpl channel) {
        Exception cause = null;
        boolean fireExceptionCaught = false;
        Object object = channel.writeLock;
        synchronized (object) {
            Queue<MessageEvent> writeBuffer;
            MessageEvent evt = channel.currentWriteEvent;
            if (evt != null) {
                cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                ChannelFuture future = evt.getFuture();
                channel.currentWriteBuffer.release();
                channel.currentWriteBuffer = null;
                channel.currentWriteEvent = null;
                evt = null;
                future.setFailure(cause);
                fireExceptionCaught = true;
            }
            if (!(writeBuffer = channel.writeBuffer).isEmpty()) {
                if (cause == null) {
                    cause = channel.isOpen() ? new NotYetConnectedException() : new ClosedChannelException();
                }
                while ((evt = writeBuffer.poll()) != null) {
                    evt.getFuture().setFailure(cause);
                    fireExceptionCaught = true;
                }
            }
        }
        if (fireExceptionCaught) {
            Channels.fireExceptionCaught(channel, (Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterestOps(SctpChannelImpl channel, ChannelFuture future, int interestOps) {
        boolean changed = false;
        try {
            Object object = channel.interestOpsLock;
            synchronized (object) {
                Selector selector = this.selector;
                SelectionKey key = channel.channel.keyFor(selector);
                if (key == null || selector == null) {
                    channel.setRawInterestOpsNow(interestOps);
                    return;
                }
                interestOps &= 0xFFFFFFFB;
                interestOps |= channel.getRawInterestOps() & 4;
                switch (CONSTRAINT_LEVEL) {
                    case 0: {
                        if (channel.getRawInterestOps() == interestOps) break;
                        key.interestOps(interestOps);
                        if (Thread.currentThread() != this.thread && this.wakenUp.compareAndSet(false, true)) {
                            selector.wakeup();
                        }
                        changed = true;
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (channel.getRawInterestOps() == interestOps) break;
                        if (Thread.currentThread() == this.thread) {
                            key.interestOps(interestOps);
                            changed = true;
                            break;
                        }
                        this.selectorGuard.readLock().lock();
                        try {
                            if (this.wakenUp.compareAndSet(false, true)) {
                                selector.wakeup();
                            }
                            key.interestOps(interestOps);
                            changed = true;
                            break;
                        }
                        finally {
                            this.selectorGuard.readLock().unlock();
                        }
                    }
                    default: {
                        throw new Error();
                    }
                }
                if (changed) {
                    channel.setRawInterestOpsNow(interestOps);
                }
            }
            future.setSuccess();
            if (changed) {
                Channels.fireChannelInterestChanged(channel);
            }
        }
        catch (CancelledKeyException e) {
            ClosedChannelException cce = new ClosedChannelException();
            future.setFailure(cce);
            Channels.fireExceptionCaught(channel, (Throwable)cce);
        }
        catch (Throwable t) {
            future.setFailure(t);
            Channels.fireExceptionCaught(channel, t);
        }
    }

    private final class RegisterTask
    implements Runnable {
        private final SctpChannelImpl channel;
        private final ChannelFuture future;
        private final boolean server;

        RegisterTask(SctpChannelImpl channel, ChannelFuture future, boolean server) {
            this.channel = channel;
            this.future = future;
            this.server = server;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            InetSocketAddress remoteAddress;
            InetSocketAddress localAddress;
            block12: {
                localAddress = this.channel.getLocalAddress();
                remoteAddress = this.channel.getRemoteAddress();
                if (localAddress == null || remoteAddress == null) {
                    if (this.future != null) {
                        this.future.setFailure(new ClosedChannelException());
                    }
                    SctpWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    return;
                }
                try {
                    if (this.server) {
                        this.channel.channel.configureBlocking(false);
                    }
                    Object object = this.channel.interestOpsLock;
                    synchronized (object) {
                        this.channel.channel.register(SctpWorker.this.selector, this.channel.getRawInterestOps(), this.channel);
                    }
                    this.channel.setConnected();
                    if (this.future != null) {
                        this.future.setSuccess();
                    }
                }
                catch (IOException e) {
                    if (this.future != null) {
                        this.future.setFailure(e);
                    }
                    SctpWorker.this.close(this.channel, Channels.succeededFuture(this.channel));
                    if (e instanceof ClosedChannelException) break block12;
                    throw new ChannelException("Failed to register a socket to the selector.", e);
                }
            }
            if (!this.server) {
                if (!((SctpClientChannel)this.channel).boundManually) {
                    Channels.fireChannelBound(this.channel, (SocketAddress)localAddress);
                }
                Channels.fireChannelConnected(this.channel, (SocketAddress)remoteAddress);
            }
        }
    }
}

