/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.oneone;

import io.netty.channel.Channel;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelUpstreamHandler;
import io.netty.channel.Channels;
import io.netty.channel.MessageEvent;

public abstract class OneToOneDecoder
implements ChannelUpstreamHandler {
    protected OneToOneDecoder() {
    }

    @Override
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        Object decodedMessage;
        if (!(evt instanceof MessageEvent)) {
            ctx.sendUpstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        Object originalMessage = e.getMessage();
        if (originalMessage == (decodedMessage = this.decode(ctx, e.getChannel(), originalMessage))) {
            ctx.sendUpstream(evt);
        } else if (decodedMessage != null) {
            Channels.fireMessageReceived(ctx, decodedMessage, e.getRemoteAddress());
        }
    }

    protected abstract Object decode(ChannelHandlerContext var1, Channel var2, Object var3) throws Exception;
}

