/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.timeout;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.Channels;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class DefaultIdleStateEvent
implements IdleStateEvent {
    private final Channel channel;
    private final IdleState state;
    private final long lastActivityTimeMillis;

    public DefaultIdleStateEvent(Channel channel, IdleState state, long lastActivityTimeMillis) {
        if (channel == null) {
            throw new NullPointerException("channel");
        }
        if (state == null) {
            throw new NullPointerException("state");
        }
        this.channel = channel;
        this.state = state;
        this.lastActivityTimeMillis = lastActivityTimeMillis;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public ChannelFuture getFuture() {
        return Channels.succeededFuture(this.getChannel());
    }

    @Override
    public IdleState getState() {
        return this.state;
    }

    @Override
    public long getLastActivityTimeMillis() {
        return this.lastActivityTimeMillis;
    }

    public String toString() {
        return this.getChannel().toString() + ' ' + (Object)((Object)this.getState()) + " since " + DateFormat.getDateTimeInstance(3, 3, Locale.US).format(new Date(this.getLastActivityTimeMillis()));
    }
}

