/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.traffic;

import io.netty.buffer.ChannelBuffer;
import io.netty.channel.Channel;
import io.netty.channel.ChannelEvent;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelState;
import io.netty.channel.ChannelStateEvent;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelHandler;
import io.netty.handler.traffic.TrafficCounter;
import io.netty.logging.InternalLogger;
import io.netty.logging.InternalLoggerFactory;
import io.netty.util.ExternalResourceReleasable;
import io.netty.util.internal.ExecutorUtil;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AbstractTrafficShapingHandler
extends SimpleChannelHandler
implements ExternalResourceReleasable {
    static InternalLogger logger = InternalLoggerFactory.getInstance(AbstractTrafficShapingHandler.class);
    public static final long DEFAULT_CHECK_INTERVAL = 1000L;
    private static final long MINIMAL_WAIT = 10L;
    protected TrafficCounter trafficCounter;
    protected Executor executor;
    private long writeLimit;
    private long readLimit;
    protected long checkInterval = 1000L;
    final AtomicBoolean release = new AtomicBoolean(false);

    private void init(Executor newExecutor, long newWriteLimit, long newReadLimit, long newCheckInterval) {
        this.executor = newExecutor;
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        this.checkInterval = newCheckInterval;
    }

    void setTrafficCounter(TrafficCounter newTrafficCounter) {
        this.trafficCounter = newTrafficCounter;
    }

    public AbstractTrafficShapingHandler(Executor executor, long writeLimit, long readLimit, long checkInterval) {
        this.init(executor, writeLimit, readLimit, checkInterval);
    }

    public AbstractTrafficShapingHandler(Executor executor, long writeLimit, long readLimit) {
        this.init(executor, writeLimit, readLimit, 1000L);
    }

    public void configure(long newWriteLimit, long newReadLimit, long newCheckInterval) {
        this.configure(newWriteLimit, newReadLimit);
        this.configure(newCheckInterval);
    }

    public void configure(long newWriteLimit, long newReadLimit) {
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(System.currentTimeMillis() + 1L);
        }
    }

    public void configure(long newCheckInterval) {
        this.checkInterval = newCheckInterval;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(this.checkInterval);
        }
    }

    protected void doAccounting(TrafficCounter counter) {
    }

    private long getTimeToWait(long limit, long bytes, long lastTime, long curtime) {
        long interval = curtime - lastTime;
        if (interval == 0L) {
            return 0L;
        }
        return bytes * 1000L / limit - interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(ChannelHandlerContext arg0, MessageEvent arg1) throws Exception {
        try {
            long curtime = System.currentTimeMillis();
            long size = ((ChannelBuffer)arg1.getMessage()).readableBytes();
            if (this.trafficCounter != null) {
                this.trafficCounter.bytesRecvFlowControl(arg0, size);
                if (this.readLimit == 0L) {
                    return;
                }
                long wait = this.getTimeToWait(this.readLimit, this.trafficCounter.getCurrentReadBytes(), this.trafficCounter.getLastTime(), curtime);
                if (wait > 10L) {
                    Channel channel = arg0.getChannel();
                    if (channel != null && channel.isConnected()) {
                        if (this.executor == null) {
                            if (this.release.get()) {
                                return;
                            }
                            Thread.sleep(wait);
                            return;
                        }
                        if (arg0.getAttachment() == null) {
                            arg0.setAttachment(Boolean.TRUE);
                            channel.setReadable(false);
                            this.executor.execute(new ReopenRead(arg0, wait));
                        } else {
                            if (this.release.get()) {
                                return;
                            }
                            Thread.sleep(wait);
                        }
                    } else {
                        if (this.release.get()) {
                            return;
                        }
                        Thread.sleep(wait);
                    }
                }
            }
        }
        finally {
            super.messageReceived(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeRequested(ChannelHandlerContext arg0, MessageEvent arg1) throws Exception {
        try {
            long curtime = System.currentTimeMillis();
            long size = ((ChannelBuffer)arg1.getMessage()).readableBytes();
            if (this.trafficCounter != null) {
                this.trafficCounter.bytesWriteFlowControl(size);
                if (this.writeLimit == 0L) {
                    return;
                }
                long wait = this.getTimeToWait(this.writeLimit, this.trafficCounter.getCurrentWrittenBytes(), this.trafficCounter.getLastTime(), curtime);
                if (wait > 10L) {
                    if (this.release.get()) {
                        return;
                    }
                    Thread.sleep(wait);
                }
            }
        }
        finally {
            super.writeRequested(arg0, arg1);
        }
    }

    @Override
    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ChannelStateEvent cse;
        if (e instanceof ChannelStateEvent && (cse = (ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS && ((Integer)cse.getValue() & 1) != 0) {
            boolean readSuspended;
            boolean bl = readSuspended = ctx.getAttachment() != null;
            if (readSuspended) {
                e.getFuture().setSuccess();
                return;
            }
        }
        super.handleDownstream(ctx, e);
    }

    public TrafficCounter getTrafficCounter() {
        return this.trafficCounter;
    }

    @Override
    public void releaseExternalResources() {
        if (this.trafficCounter != null) {
            this.trafficCounter.stop();
        }
        this.release.set(true);
        ExecutorUtil.terminate(this.executor);
    }

    public String toString() {
        return "TrafficShaping with Write Limit: " + this.writeLimit + " Read Limit: " + this.readLimit + " and Counter: " + (this.trafficCounter != null ? this.trafficCounter.toString() : "none");
    }

    private class ReopenRead
    implements Runnable {
        private ChannelHandlerContext ctx;
        private long timeToWait;

        protected ReopenRead(ChannelHandlerContext ctx, long timeToWait) {
            this.ctx = ctx;
            this.timeToWait = timeToWait;
        }

        @Override
        public void run() {
            try {
                if (AbstractTrafficShapingHandler.this.release.get()) {
                    return;
                }
                Thread.sleep(this.timeToWait);
            }
            catch (InterruptedException e) {
                return;
            }
            if (this.ctx != null && this.ctx.getChannel() != null && this.ctx.getChannel().isConnected()) {
                this.ctx.setAttachment(null);
                this.ctx.getChannel().setReadable(true);
            }
        }
    }
}

