/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.auth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.uberfire.security.SecurityContext;
import org.uberfire.security.auth.AuthenticationException;
import org.uberfire.security.auth.AuthenticationProvider;
import org.uberfire.security.auth.AuthenticationResult;
import org.uberfire.security.auth.AuthenticationStatus;
import org.uberfire.security.auth.Credential;
import org.uberfire.security.auth.Principal;
import org.uberfire.security.impl.auth.PrincipalImpl;
import org.uberfire.security.server.auth.RememberMeCookieAuthScheme;

public class RememberMeCookieAuthProvider
implements AuthenticationProvider {
    public void initialize(Map<String, ?> options) {
    }

    public boolean supportsCredential(Credential credential) {
        if (credential == null) {
            return false;
        }
        return credential instanceof RememberMeCookieAuthScheme.RememberMeCredential;
    }

    public AuthenticationResult authenticate(Credential credential, SecurityContext securityContext) throws AuthenticationException {
        if (!this.supportsCredential(credential)) {
            return new AuthenticationResult(){

                public List<String> getMessages() {
                    return new ArrayList<String>(1){
                        {
                            this.add("Credential not supported by " + RememberMeCookieAuthProvider.class.getName());
                        }
                    };
                }

                public AuthenticationStatus getStatus() {
                    return AuthenticationStatus.NONE;
                }

                public Principal getPrincipal() {
                    return null;
                }
            };
        }
        final RememberMeCookieAuthScheme.RememberMeCredential realCredential = (RememberMeCookieAuthScheme.RememberMeCredential)RememberMeCookieAuthScheme.RememberMeCredential.class.cast(credential);
        return new AuthenticationResult(){

            public List<String> getMessages() {
                return Collections.emptyList();
            }

            public AuthenticationStatus getStatus() {
                return AuthenticationStatus.SUCCESS;
            }

            public Principal getPrincipal() {
                return new PrincipalImpl(realCredential.getUserId());
            }
        };
    }
}

