/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.server.cdi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Produces;
import org.uberfire.security.Identity;
import org.uberfire.security.Role;
import org.uberfire.security.Subject;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.impl.IdentityImpl;
import org.uberfire.security.impl.RoleImpl;
import org.uberfire.security.server.cdi.AppResourcesAuthz;

public class SecurityFactory {
    private static final List<Role> ANONYMOUS_ROLE = new ArrayList<Role>(){
        {
            this.add(new RoleImpl("Anonymous"));
        }
    };
    private static final ThreadLocal<Subject> subjects = new ThreadLocal();
    private static AuthorizationManager authzManager = null;

    public static void setSubject(Subject subject) {
        subjects.set(subject);
    }

    public static void setAuthzManager(AuthorizationManager authzManager) {
        SecurityFactory.authzManager = authzManager;
    }

    @Produces
    @RequestScoped
    public static Identity getIdentity() {
        if (subjects.get() == null) {
            return new IdentityImpl("Anonymous", ANONYMOUS_ROLE, Collections.emptyMap());
        }
        return new IdentityImpl(subjects.get().getName(), subjects.get().getRoles(), subjects.get().getProperties());
    }

    @Produces
    @ApplicationScoped
    @AppResourcesAuthz
    public static AuthorizationManager getAuthzManager() {
        return authzManager;
    }
}

