/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.List;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.apache.helix.HelixManager;
import org.apache.helix.HelixTimerTask;
import org.apache.helix.PropertyKey;
import org.apache.helix.controller.GenericHelixController;
import org.apache.helix.manager.zk.DefaultControllerMessageHandlerFactory;
import org.apache.helix.manager.zk.DefaultParticipantErrorMessageHandlerFactory;
import org.apache.helix.manager.zk.DefaultSchedulerMessageHandlerFactory;
import org.apache.helix.messaging.DefaultMessagingService;
import org.apache.log4j.Logger;

public class ControllerManagerHelper {
    private static Logger LOG = Logger.getLogger(ControllerManagerHelper.class);
    final HelixManager _manager;
    final DefaultMessagingService _messagingService;
    final List<HelixTimerTask> _controllerTimerTasks;

    public ControllerManagerHelper(HelixManager manager, List<HelixTimerTask> controllerTimerTasks) {
        this._manager = manager;
        this._messagingService = (DefaultMessagingService)manager.getMessagingService();
        this._controllerTimerTasks = controllerTimerTasks;
    }

    public void addListenersToController(GenericHelixController controller) {
        try {
            this._manager.addControllerMessageListener(this._messagingService.getExecutor());
            DefaultControllerMessageHandlerFactory defaultControllerMsgHandlerFactory = new DefaultControllerMessageHandlerFactory();
            this._messagingService.getExecutor().registerMessageHandlerFactory(defaultControllerMsgHandlerFactory.getMessageType(), defaultControllerMsgHandlerFactory);
            DefaultSchedulerMessageHandlerFactory defaultSchedulerMsgHandlerFactory = new DefaultSchedulerMessageHandlerFactory(this._manager);
            this._messagingService.getExecutor().registerMessageHandlerFactory(defaultSchedulerMsgHandlerFactory.getMessageType(), defaultSchedulerMsgHandlerFactory);
            DefaultParticipantErrorMessageHandlerFactory defaultParticipantErrorMessageHandlerFactory = new DefaultParticipantErrorMessageHandlerFactory(this._manager);
            this._messagingService.getExecutor().registerMessageHandlerFactory(defaultParticipantErrorMessageHandlerFactory.getMessageType(), defaultParticipantErrorMessageHandlerFactory);
            this._manager.addConfigChangeListener(controller);
            this._manager.addLiveInstanceChangeListener(controller);
            this._manager.addIdealStateChangeListener(controller);
            this._manager.addControllerListener(controller);
        }
        catch (ZkInterruptedException e) {
            LOG.warn((Object)("zk connection is interrupted during HelixManagerMain.addListenersToController(). " + (Object)((Object)e)));
        }
        catch (Exception e) {
            LOG.error((Object)"Error when creating HelixManagerContollerMonitor", (Throwable)e);
        }
    }

    public void removeListenersFromController(GenericHelixController controller) {
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(this._manager.getClusterName());
        this._manager.removeListener(keyBuilder.instanceConfigs(), controller);
        this._manager.removeListener(keyBuilder.liveInstances(), controller);
        this._manager.removeListener(keyBuilder.idealStates(), controller);
        this._manager.removeListener(keyBuilder.controller(), controller);
        this._manager.removeListener(keyBuilder.controllerMessages(), this._messagingService.getExecutor());
    }

    public void startControllerTimerTasks() {
        for (HelixTimerTask task : this._controllerTimerTasks) {
            task.start();
        }
    }

    public void stopControllerTimerTasks() {
        for (HelixTimerTask task : this._controllerTimerTasks) {
            task.stop();
        }
    }
}

