/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.messaging.handling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.HelixException;
import org.apache.helix.HelixManager;
import org.apache.helix.MessageListener;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.messaging.handling.HelixTask;
import org.apache.helix.messaging.handling.HelixTaskResult;
import org.apache.helix.messaging.handling.MessageHandler;
import org.apache.helix.messaging.handling.MessageHandlerFactory;
import org.apache.helix.messaging.handling.MessageTask;
import org.apache.helix.messaging.handling.MessageTaskInfo;
import org.apache.helix.messaging.handling.MessageTimeoutTask;
import org.apache.helix.messaging.handling.TaskExecutor;
import org.apache.helix.model.ConfigScope;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.Message;
import org.apache.helix.model.builder.ConfigScopeBuilder;
import org.apache.helix.monitoring.ParticipantMonitor;
import org.apache.helix.participant.HelixStateMachineEngine;
import org.apache.helix.util.StatusUpdateUtil;
import org.apache.log4j.Logger;

public class HelixTaskExecutor
implements MessageListener,
TaskExecutor {
    public static final int DEFAULT_PARALLEL_TASKS = 40;
    protected final Map<String, MessageTaskInfo> _taskMap;
    private final Object _lock;
    private final StatusUpdateUtil _statusUpdateUtil;
    private final ParticipantMonitor _monitor;
    public static final String MAX_THREADS = "maxThreads";
    final ConcurrentHashMap<String, MessageHandlerFactory> _handlerFactoryMap = new ConcurrentHashMap();
    final ConcurrentHashMap<String, ExecutorService> _executorMap;
    private static Logger LOG = Logger.getLogger(HelixTaskExecutor.class);
    Map<String, Integer> _resourceThreadpoolSizeMap = new ConcurrentHashMap<String, Integer>();
    final Timer _timer;

    public HelixTaskExecutor() {
        this._taskMap = new ConcurrentHashMap<String, MessageTaskInfo>();
        this._executorMap = new ConcurrentHashMap();
        this._lock = new Object();
        this._statusUpdateUtil = new StatusUpdateUtil();
        this._monitor = new ParticipantMonitor();
        this._timer = new Timer(true);
        this.startMonitorThread();
    }

    @Override
    public void registerMessageHandlerFactory(String type, MessageHandlerFactory factory) {
        this.registerMessageHandlerFactory(type, factory, 40);
    }

    @Override
    public void registerMessageHandlerFactory(String type, MessageHandlerFactory factory, int threadpoolSize) {
        if (!this._handlerFactoryMap.containsKey(type)) {
            if (!type.equalsIgnoreCase(factory.getMessageType())) {
                throw new HelixException("Message factory type mismatch. Type: " + type + " factory : " + factory.getMessageType());
            }
            this._handlerFactoryMap.put(type, factory);
            ExecutorService executorSvc = Executors.newFixedThreadPool(threadpoolSize);
            this._executorMap.put(type, executorSvc);
            LOG.info((Object)("Added msg-factory for type: " + type + ", threadpool size " + threadpoolSize));
        } else {
            LOG.warn((Object)("Fail to register msg-handler-factory for type: " + type + ", pool-size: " + threadpoolSize + ", factory: " + factory));
        }
    }

    public ParticipantMonitor getParticipantMonitor() {
        return this._monitor;
    }

    private void startMonitorThread() {
    }

    void checkResourceConfig(String resourceName, HelixManager manager) {
        if (!this._resourceThreadpoolSizeMap.containsKey(resourceName)) {
            int threadpoolSize = -1;
            ConfigAccessor configAccessor = manager.getConfigAccessor();
            if (configAccessor != null) {
                ConfigScope scope = new ConfigScopeBuilder().forCluster(manager.getClusterName()).forResource(resourceName).build();
                String threadpoolSizeStr = configAccessor.get(scope, MAX_THREADS);
                try {
                    if (threadpoolSizeStr != null) {
                        threadpoolSize = Integer.parseInt(threadpoolSizeStr);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"", (Throwable)e);
                }
            }
            if (threadpoolSize > 0) {
                String key = Message.MessageType.STATE_TRANSITION.toString() + "." + resourceName;
                this._executorMap.put(key, Executors.newFixedThreadPool(threadpoolSize));
                LOG.info((Object)("Added per resource threadpool for resource: " + resourceName + " with size: " + threadpoolSize));
            }
            this._resourceThreadpoolSizeMap.put(resourceName, threadpoolSize);
        }
    }

    ExecutorService findExecutorServiceForMsg(Message message) {
        String key;
        String resourceName;
        ExecutorService executorService = this._executorMap.get(message.getMsgType());
        if (message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.toString()) && (resourceName = message.getResourceName()) != null && this._executorMap.containsKey(key = message.getMsgType() + "." + resourceName)) {
            LOG.info((Object)("Find per-resource thread pool with key: " + key));
            executorService = this._executorMap.get(key);
        }
        return executorService;
    }

    @Override
    public List<Future<HelixTaskResult>> invokeAllTasks(List<MessageTask> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (tasks == null || tasks.size() == 0) {
            return null;
        }
        ExecutorService exeSvc = this.findExecutorServiceForMsg(tasks.get(0).getMessage());
        for (int i = 1; i < tasks.size(); ++i) {
            MessageTask task = tasks.get(i);
            ExecutorService curExeSvc = this.findExecutorServiceForMsg(task.getMessage());
            if (curExeSvc == exeSvc) continue;
            LOG.error((Object)"Fail to invoke all tasks because they are not using the same executor-service");
            return null;
        }
        List<Future<HelixTaskResult>> futures = exeSvc.invokeAll(tasks, timeout, unit);
        return futures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelTimeoutTask(MessageTask task) {
        Object object = this._lock;
        synchronized (object) {
            String taskId = task.getTaskId();
            if (this._taskMap.containsKey(taskId)) {
                MessageTaskInfo info = this._taskMap.get(taskId);
                if (info._timerTask != null) {
                    info._timerTask.cancel();
                }
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scheduleTask(MessageTask task) {
        String taskId = task.getTaskId();
        Message message = task.getMessage();
        NotificationContext notificationContext = task.getNotificationContext();
        try {
            if (message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.toString())) {
                this.checkResourceConfig(message.getResourceName(), notificationContext.getManager());
            }
            LOG.info((Object)("Scheduling message: " + taskId));
            this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "Message handling task scheduled", notificationContext.getManager().getHelixDataAccessor());
            Object object = this._lock;
            synchronized (object) {
                if (!this._taskMap.containsKey(taskId)) {
                    ExecutorService exeSvc = this.findExecutorServiceForMsg(message);
                    Future<HelixTaskResult> future = exeSvc.submit(task);
                    MessageTimeoutTask timerTask = null;
                    if (message.getExecutionTimeout() > 0) {
                        timerTask = new MessageTimeoutTask(this, task);
                        this._timer.schedule((TimerTask)timerTask, message.getExecutionTimeout());
                        LOG.info((Object)("Message starts with timeout " + message.getExecutionTimeout() + " MsgId: " + task.getTaskId()));
                    } else {
                        LOG.debug((Object)("Message does not have timeout. MsgId: " + task.getTaskId()));
                    }
                    this._taskMap.put(taskId, new MessageTaskInfo(task, future, timerTask));
                    LOG.info((Object)("Message: " + taskId + " handling task scheduled"));
                    return true;
                }
                this._statusUpdateUtil.logWarning(message, HelixTaskExecutor.class, "Message handling task already sheduled for " + taskId, notificationContext.getManager().getHelixDataAccessor());
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error while executing task. " + message), (Throwable)e);
            this._statusUpdateUtil.logError(message, HelixTaskExecutor.class, e, "Error while executing task " + e, notificationContext.getManager().getHelixDataAccessor());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelTask(MessageTask task) {
        Message message = task.getMessage();
        NotificationContext notificationContext = task.getNotificationContext();
        String taskId = task.getTaskId();
        Object object = this._lock;
        synchronized (object) {
            if (this._taskMap.containsKey(taskId)) {
                MessageTaskInfo taskInfo = this._taskMap.get(taskId);
                if (taskInfo._timerTask != null) {
                    taskInfo._timerTask.cancel();
                }
                Future<HelixTaskResult> future = taskInfo.getFuture();
                this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "Canceling task: " + taskId, notificationContext.getManager().getHelixDataAccessor());
                if (future.cancel(true)) {
                    this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "Canceled task: " + taskId, notificationContext.getManager().getHelixDataAccessor());
                    this._taskMap.remove(taskId);
                    return true;
                }
                this._statusUpdateUtil.logInfo(message, HelixTaskExecutor.class, "fail to cancel task: " + taskId, notificationContext.getManager().getHelixDataAccessor());
            } else {
                this._statusUpdateUtil.logWarning(message, HelixTaskExecutor.class, "fail to cancel task: " + taskId + ", future not found", notificationContext.getManager().getHelixDataAccessor());
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishTask(MessageTask task) {
        Message message = task.getMessage();
        String taskId = task.getTaskId();
        LOG.info((Object)("message finished: " + taskId + ", took " + (new Date().getTime() - message.getExecuteStartTimeStamp())));
        Object object = this._lock;
        synchronized (object) {
            if (this._taskMap.containsKey(taskId)) {
                MessageTaskInfo info = this._taskMap.remove(taskId);
                if (info._timerTask != null) {
                    info._timerTask.cancel();
                }
            } else {
                LOG.warn((Object)("message " + taskId + " not found in task map"));
            }
        }
    }

    private void updateMessageState(List<Message> readMsgs, HelixDataAccessor accessor, String instanceName) {
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        ArrayList<PropertyKey> readMsgKeys = new ArrayList<PropertyKey>();
        for (Message msg : readMsgs) {
            readMsgKeys.add(msg.getKey(keyBuilder, instanceName));
        }
        accessor.setChildren(readMsgKeys, readMsgs);
    }

    void unregisterMessageHandlerFactory(String type) {
        MessageHandlerFactory handlerFty;
        ExecutorService executorSvc = this._executorMap.remove(type);
        if (executorSvc != null) {
            List<Runnable> tasksLeft = executorSvc.shutdownNow();
            LOG.info((Object)(tasksLeft.size() + " tasks never executed for msgType: " + type + ". tasks: " + tasksLeft));
            try {
                if (!executorSvc.awaitTermination(200L, TimeUnit.MILLISECONDS)) {
                    LOG.error((Object)("executor-service for msgType: " + type + " is not fully terminated in 200ms. will disconnect helix-participant"));
                    throw new HelixException("fail to unregister msg-handler for msgType: " + type);
                }
            }
            catch (InterruptedException e) {
                LOG.error((Object)("interruped when waiting for executor-service shutdown for msgType: " + type), (Throwable)e);
            }
        }
        if ((handlerFty = this._handlerFactoryMap.remove(type)) != null) {
            handlerFty.reset();
        }
    }

    void reset() {
        LOG.info((Object)"Get FINALIZE notification");
        for (String msgType : this._executorMap.keySet()) {
            this.unregisterMessageHandlerFactory(msgType);
        }
        this._taskMap.clear();
    }

    @Override
    public void onMessage(String instanceName, List<Message> messages, NotificationContext changeContext) {
        if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
            this.reset();
            return;
        }
        if (messages == null || messages.size() == 0) {
            LOG.info((Object)"No Messages to process");
            return;
        }
        Collections.sort(messages, Message.CREATE_TIME_COMPARATOR);
        HelixManager manager = changeContext.getManager();
        HelixDataAccessor accessor = manager.getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        ArrayList<MessageHandler> handlers = new ArrayList<MessageHandler>();
        ArrayList<Message> readMsgs = new ArrayList<Message>();
        String sessionId = manager.getSessionId();
        List<String> curResourceNames = accessor.getChildNames(keyBuilder.currentStates(instanceName, sessionId));
        ArrayList<PropertyKey> createCurStateKeys = new ArrayList<PropertyKey>();
        ArrayList<CurrentState> metaCurStates = new ArrayList<CurrentState>();
        HashSet<String> createCurStateNames = new HashSet<String>();
        for (Message message : messages) {
            String resourceName;
            if (message.getMsgType().equalsIgnoreCase(Message.MessageType.NO_OP.toString())) {
                LOG.info((Object)("Dropping NO-OP message. mid: " + message.getId() + ", from: " + message.getMsgSrc()));
                accessor.removeProperty(message.getKey(keyBuilder, instanceName));
                continue;
            }
            String tgtSessionId = message.getTgtSessionId();
            if (!sessionId.equals(tgtSessionId) && !tgtSessionId.equals("*")) {
                String warningMessage = "SessionId does NOT match. expected sessionId: " + sessionId + ", tgtSessionId in message: " + tgtSessionId + ", messageId: " + message.getMsgId();
                LOG.warn((Object)warningMessage);
                accessor.removeProperty(message.getKey(keyBuilder, instanceName));
                this._statusUpdateUtil.logWarning(message, HelixStateMachineEngine.class, warningMessage, accessor);
                continue;
            }
            if (Message.MessageState.NEW != message.getMsgState()) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Message already read. msgId: " + message.getMsgId()));
                continue;
            }
            try {
                MessageHandler createHandler = this.createMessageHandler(message, changeContext);
                if (createHandler == null) continue;
                handlers.add(createHandler);
            }
            catch (Exception e) {
                LOG.error((Object)("Failed to create message handler for " + message.getMsgId()), (Throwable)e);
                String error = "Failed to create message handler for " + message.getMsgId() + ", exception: " + e;
                this._statusUpdateUtil.logError(message, HelixStateMachineEngine.class, e, error, accessor);
                message.setMsgState(Message.MessageState.UNPROCESSABLE);
                accessor.removeProperty(message.getKey(keyBuilder, instanceName));
                LOG.error((Object)("Message cannot be processed: " + message.getRecord()), (Throwable)e);
                continue;
            }
            message.setMsgState(Message.MessageState.READ);
            message.setReadTimeStamp(new Date().getTime());
            message.setExecuteSessionId(changeContext.getManager().getSessionId());
            this._statusUpdateUtil.logInfo(message, HelixStateMachineEngine.class, "New Message", accessor);
            readMsgs.add(message);
            if (message.isControlerMsg() || !message.getMsgType().equals(Message.MessageType.STATE_TRANSITION.toString()) || curResourceNames.contains(resourceName = message.getResourceName()) || createCurStateNames.contains(resourceName)) continue;
            createCurStateNames.add(resourceName);
            createCurStateKeys.add(keyBuilder.currentState(instanceName, sessionId, resourceName));
            CurrentState metaCurState = new CurrentState(resourceName);
            metaCurState.setBucketSize(message.getBucketSize());
            metaCurState.setStateModelDefRef(message.getStateModelDef());
            metaCurState.setSessionId(sessionId);
            metaCurState.setBatchMessageMode(message.getBatchMessageMode());
            String ftyName = message.getStateModelFactoryName();
            if (ftyName != null) {
                metaCurState.setStateModelFactoryName(ftyName);
            } else {
                metaCurState.setStateModelFactoryName("DEFAULT");
            }
            metaCurStates.add(metaCurState);
        }
        if (createCurStateKeys.size() > 0) {
            try {
                accessor.createChildren(createCurStateKeys, metaCurStates);
            }
            catch (Exception e) {
                LOG.error((Object)("fail to create cur-state znodes for messages: " + readMsgs), (Throwable)e);
            }
        }
        if (readMsgs.size() > 0) {
            this.updateMessageState(readMsgs, accessor, instanceName);
            for (MessageHandler handler : handlers) {
                HelixTask task = new HelixTask(handler._message, changeContext, handler, this);
                this.scheduleTask(task);
            }
        }
    }

    public MessageHandler createMessageHandler(Message message, NotificationContext changeContext) {
        String msgType = message.getMsgType().toString();
        MessageHandlerFactory handlerFactory = this._handlerFactoryMap.get(msgType);
        if (handlerFactory == null) {
            LOG.warn((Object)("Fail to find message handler factory for type: " + msgType + " msgId: " + message.getMsgId()));
            return null;
        }
        changeContext.add(NotificationContext.MapKey.TASK_EXECUTOR.toString(), this);
        return handlerFactory.createHandler(message, changeContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        LOG.info((Object)"shutting down TaskExecutor");
        this._timer.cancel();
        Object object = this._lock;
        synchronized (object) {
            for (String msgType : this._executorMap.keySet()) {
                List<Runnable> tasksLeft = this._executorMap.get(msgType).shutdownNow();
                LOG.info((Object)(tasksLeft.size() + " tasks are still in the threadpool for msgType " + msgType));
            }
            for (String msgType : this._executorMap.keySet()) {
                try {
                    if (this._executorMap.get(msgType).awaitTermination(200L, TimeUnit.MILLISECONDS)) continue;
                    LOG.warn((Object)(msgType + " is not fully termimated in 200 MS"));
                    System.out.println(msgType + " is not fully termimated in 200 MS");
                }
                catch (InterruptedException e) {
                    LOG.error((Object)"Interrupted", (Throwable)e);
                }
            }
        }
        this._monitor.shutDown();
        LOG.info((Object)"shutdown finished");
    }
}

