/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http.snoop;

import io.netty.buffer.ChannelBuffer;
import io.netty.buffer.ChannelBuffers;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ExceptionEvent;
import io.netty.channel.MessageEvent;
import io.netty.channel.SimpleChannelUpstreamHandler;
import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieDecoder;
import io.netty.handler.codec.http.CookieEncoder;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunk;
import io.netty.handler.codec.http.HttpChunkTrailer;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpSnoopServerHandler
extends SimpleChannelUpstreamHandler {
    private HttpRequest request;
    private boolean readingChunks;
    private final StringBuilder buf = new StringBuilder();

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (!this.readingChunks) {
            this.request = (HttpRequest)e.getMessage();
            HttpRequest request = this.request;
            if (HttpHeaders.is100ContinueExpected(request)) {
                this.send100Continue(e);
            }
            this.buf.setLength(0);
            this.buf.append("WELCOME TO THE WILD WILD WEB SERVER\r\n");
            this.buf.append("===================================\r\n");
            this.buf.append("VERSION: " + request.getProtocolVersion() + "\r\n");
            this.buf.append("HOSTNAME: " + HttpHeaders.getHost(request, "unknown") + "\r\n");
            this.buf.append("REQUEST_URI: " + request.getUri() + "\r\n\r\n");
            for (Map.Entry<String, String> h : request.getHeaders()) {
                this.buf.append("HEADER: " + h.getKey() + " = " + h.getValue() + "\r\n");
            }
            this.buf.append("\r\n");
            QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.getUri());
            Map<String, List<String>> params = queryStringDecoder.getParameters();
            if (!params.isEmpty()) {
                for (Map.Entry<String, List<String>> p : params.entrySet()) {
                    String key = p.getKey();
                    List<String> vals = p.getValue();
                    for (String val : vals) {
                        this.buf.append("PARAM: " + key + " = " + val + "\r\n");
                    }
                }
                this.buf.append("\r\n");
            }
            if (request.isChunked()) {
                this.readingChunks = true;
            } else {
                ChannelBuffer content = request.getContent();
                if (content.readable()) {
                    this.buf.append("CONTENT: " + content.toString(CharsetUtil.UTF_8) + "\r\n");
                }
                this.writeResponse(e);
            }
        } else {
            HttpChunk chunk = (HttpChunk)e.getMessage();
            if (chunk.isLast()) {
                this.readingChunks = false;
                this.buf.append("END OF CONTENT\r\n");
                HttpChunkTrailer trailer = (HttpChunkTrailer)chunk;
                if (!trailer.getHeaderNames().isEmpty()) {
                    this.buf.append("\r\n");
                    for (String name : trailer.getHeaderNames()) {
                        for (String value : trailer.getHeaders(name)) {
                            this.buf.append("TRAILING HEADER: " + name + " = " + value + "\r\n");
                        }
                    }
                    this.buf.append("\r\n");
                }
                this.writeResponse(e);
            } else {
                this.buf.append("CHUNK: " + chunk.getContent().toString(CharsetUtil.UTF_8) + "\r\n");
            }
        }
    }

    private void writeResponse(MessageEvent e) {
        CookieDecoder cookieDecoder;
        Set<Cookie> cookies;
        String cookieString;
        boolean keepAlive = HttpHeaders.isKeepAlive(this.request);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.setContent(ChannelBuffers.copiedBuffer(this.buf.toString(), CharsetUtil.UTF_8));
        response.setHeader("Content-Type", "text/plain; charset=UTF-8");
        if (keepAlive) {
            response.setHeader("Content-Length", response.getContent().readableBytes());
        }
        if ((cookieString = this.request.getHeader("Cookie")) != null && !(cookies = (cookieDecoder = new CookieDecoder()).decode(cookieString)).isEmpty()) {
            CookieEncoder cookieEncoder = new CookieEncoder(true);
            for (Cookie cookie : cookies) {
                cookieEncoder.addCookie(cookie);
            }
            response.addHeader("Set-Cookie", cookieEncoder.encode());
        }
        ChannelFuture future = e.getChannel().write(response);
        if (!keepAlive) {
            future.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private void send100Continue(MessageEvent e) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE);
        e.getChannel().write(response);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        e.getCause().printStackTrace();
        e.getChannel().close();
    }
}

