/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.sctp;

import io.netty.bootstrap.ClientBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineFactory;
import io.netty.channel.Channels;
import io.netty.channel.sctp.SctpClientSocketChannelFactory;
import io.netty.example.sctp.SctpClientHandler;
import io.netty.handler.execution.ExecutionHandler;
import io.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;

public class SctpClient {
    private final String host;
    private final int port;

    public SctpClient(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public void run() {
        ClientBootstrap bootstrap = new ClientBootstrap(new SctpClientSocketChannelFactory(Executors.newCachedThreadPool(), Executors.newCachedThreadPool()));
        final ExecutionHandler executionHandler = new ExecutionHandler(new OrderedMemoryAwareThreadPoolExecutor(16, 0x100000L, 0x100000L));
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                return Channels.pipeline(executionHandler, new SctpClientHandler());
            }
        });
        bootstrap.setOption("sendBufferSize", 0x100000);
        bootstrap.setOption("receiveBufferSize", 0x100000);
        bootstrap.setOption("sctpNoDelay", true);
        ChannelFuture future = bootstrap.connect(new InetSocketAddress(this.host, this.port));
        future.getChannel().getCloseFuture().awaitUninterruptibly();
        bootstrap.releaseExternalResources();
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("Usage: " + SctpClient.class.getSimpleName() + " <host> <port>");
            return;
        }
        String host = args[0];
        int port = Integer.parseInt(args[1]);
        new SctpClient(host, port).run();
    }
}

